/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.realtime;

import java.util.Map;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;

public class PipeRealtimeEvent
extends EnrichedEvent {
    private final EnrichedEvent event;
    private final TsFileEpoch tsFileEpoch;
    private Map<String, String[]> device2Measurements;

    public PipeRealtimeEvent(EnrichedEvent event, TsFileEpoch tsFileEpoch, Map<String, String[]> device2Measurements, String pattern) {
        this(event, tsFileEpoch, device2Measurements, null, pattern, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeRealtimeEvent(EnrichedEvent event, TsFileEpoch tsFileEpoch, Map<String, String[]> device2Measurements, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        super(event != null ? event.getPipeName() : null, pipeTaskMeta, pattern, startTime, endTime);
        this.event = event;
        this.tsFileEpoch = tsFileEpoch;
        this.device2Measurements = device2Measurements;
    }

    public EnrichedEvent getEvent() {
        return this.event;
    }

    public TsFileEpoch getTsFileEpoch() {
        return this.tsFileEpoch;
    }

    public Map<String, String[]> getSchemaInfo() {
        return this.device2Measurements;
    }

    public void gcSchemaInfo() {
        this.device2Measurements = null;
    }

    @Override
    public boolean increaseReferenceCount(String holderMessage) {
        return this.event.increaseReferenceCount(holderMessage);
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return this.event.internallyIncreaseResourceReferenceCount(holderMessage);
    }

    @Override
    public boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        return this.event.decreaseReferenceCount(holderMessage, shouldReport);
    }

    @Override
    public boolean clearReferenceCount(String holderMessage) {
        return this.event.clearReferenceCount(holderMessage);
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return this.event.internallyDecreaseResourceReferenceCount(holderMessage);
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.event.getProgressIndex();
    }

    @Override
    public void skipParsingPattern() {
        this.event.skipParsingPattern();
    }

    @Override
    public void skipParsingTime() {
        this.event.skipParsingTime();
    }

    @Override
    public PipeRealtimeEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, String pattern, long startTime, long endTime) {
        return new PipeRealtimeEvent(this.event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(pipeName, pipeTaskMeta, pattern, startTime, endTime), this.tsFileEpoch, this.device2Measurements, pipeTaskMeta, pattern, startTime, endTime);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return this.event.isGeneratedByPipe();
    }

    @Override
    public boolean mayEventTimeOverlappedWithTimeRange() {
        return this.event.mayEventTimeOverlappedWithTimeRange();
    }

    @Override
    public String toString() {
        return "PipeRealtimeEvent{event=" + this.event + ", tsFileEpoch=" + this.tsFileEpoch + ", device2Measurements=" + this.device2Measurements + '}';
    }
}

