/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.RemoveConfigNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveConfigNodeProcedure
extends AbstractNodeProcedure<RemoveConfigNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveConfigNodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TConfigNodeLocation removedConfigNode;

    public RemoveConfigNodeProcedure() {
    }

    public RemoveConfigNodeProcedure(TConfigNodeLocation removedConfigNode) {
        this.removedConfigNode = removedConfigNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveConfigNodeState state) {
        block9: {
            if (this.removedConfigNode == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case REMOVE_PEER: {
                        env.removeConfigNodePeer(this.removedConfigNode);
                        this.setNextState(RemoveConfigNodeState.DELETE_PEER);
                        LOG.info("Remove peer for ConfigNode: {}", (Object)this.removedConfigNode);
                        break;
                    }
                    case DELETE_PEER: {
                        env.deleteConfigNodePeer(this.removedConfigNode);
                        this.setNextState(RemoveConfigNodeState.STOP_CONFIG_NODE);
                        LOG.info("Delete peer for ConfigNode: {}", (Object)this.removedConfigNode);
                        break;
                    }
                    case STOP_CONFIG_NODE: {
                        env.broadCastTheLatestConfigNodeGroup();
                        env.stopConfigNode(this.removedConfigNode);
                        LOG.info("Stop ConfigNode: {}", (Object)this.removedConfigNode);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Remove Config Node" + this.removedConfigNode + " failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to remove config node {}, state {}", new Object[]{this.removedConfigNode, state, e});
                if (this.getCycles() <= 5) break block9;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RemoveConfigNodeState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RemoveConfigNodeState state) {
        return true;
    }

    @Override
    protected RemoveConfigNodeState getState(int stateId) {
        return RemoveConfigNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveConfigNodeState deleteStorageGroupState) {
        return deleteStorageGroupState.ordinal();
    }

    @Override
    protected RemoveConfigNodeState getInitialState() {
        return RemoveConfigNodeState.REMOVE_PEER;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REMOVE_CONFIG_NODE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftConfigNodeSerDeUtils.serializeTConfigNodeLocation((TConfigNodeLocation)this.removedConfigNode, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.removedConfigNode = ThriftConfigNodeSerDeUtils.deserializeTConfigNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RemoveConfigNodeProcedure) {
            RemoveConfigNodeProcedure thatProc = (RemoveConfigNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.removedConfigNode.equals(this.removedConfigNode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.removedConfigNode);
    }
}

