/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.execution;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.task.DecoratingLock;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigNodeSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigNodeSubtask.class);
    private final PipeExtractor extractor;
    private final PipeProcessor processor;
    private final PipeConnector connector;
    private final DecoratingLock callbackDecoratingLock = new DecoratingLock();
    private ExecutorService subtaskCallbackListeningExecutor;
    private volatile boolean isSubmitted = false;

    public PipeConfigNodeSubtask(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        super(pipeName, creationTime);
        this.extractor = this.initExtractor(extractorAttributes);
        this.processor = this.initProcessor(processorAttributes);
        this.connector = this.initConnector(connectorAttributes);
    }

    private PipeExtractor initExtractor(Map<String, String> extractorAttributes) throws Exception {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        PipeExtractor extractor = PipeConfigNodeAgent.plugin().reflectExtractor(extractorParameters);
        extractor.validate(new PipeParameterValidator(extractorParameters));
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskRuntimeEnvironment(this.taskID, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId()));
        extractor.customize(extractorParameters, (PipeExtractorRuntimeConfiguration)runtimeConfiguration);
        return extractor;
    }

    private PipeProcessor initProcessor(Map<String, String> processorAttributes) throws Exception {
        PipeParameters processorParameters = new PipeParameters(processorAttributes);
        PipeProcessor processor = PipeConfigNodeAgent.plugin().reflectProcessor(processorParameters);
        processor.validate(new PipeParameterValidator(processorParameters));
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskRuntimeEnvironment(this.taskID, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId()));
        processor.customize(processorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
        return processor;
    }

    private PipeConnector initConnector(Map<String, String> connectorAttributes) throws Exception {
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        PipeConnector connector = PipeConfigNodeAgent.plugin().reflectConnector(connectorParameters);
        connector.validate(new PipeParameterValidator(connectorParameters));
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskRuntimeEnvironment(this.taskID, this.creationTime, ConfigNodeInfo.CONFIG_REGION_ID.getId()));
        connector.customize(connectorParameters, (PipeConnectorRuntimeConfiguration)runtimeConfiguration);
        connector.handshake();
        return connector;
    }

    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService subtaskCallbackListeningExecutor, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskCallbackListeningExecutor = subtaskCallbackListeningExecutor;
        this.subtaskScheduler = subtaskScheduler;
    }

    protected boolean executeOnce() throws Exception {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : this.extractor.supply();
        this.setLastEvent(event);
        try {
            if (event == null) {
                return false;
            }
            this.connector.transfer(event);
            this.releaseLastEvent(true);
        }
        catch (PipeConnectionException e) {
            if (!this.isClosed.get()) {
                throw e;
            }
            LOGGER.info("PipeConnectionException in pipe transfer, ignored because pipe is dropped.");
            this.releaseLastEvent(false);
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                throw new PipeException("Error occurred during executing PipeConnector#transfer.", (Throwable)e);
            }
            LOGGER.info("Exception in pipe transfer, ignored because pipe is dropped.");
            this.releaseLastEvent(false);
        }
        return true;
    }

    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = super.call();
        this.callbackDecoratingLock.waitForDecorated();
        return hasAtLeastOneEventProcessed;
    }

    public synchronized void onSuccess(Boolean hasAtLeastOneEventProcessed) {
        this.isSubmitted = false;
        super.onSuccess(hasAtLeastOneEventProcessed);
    }

    public synchronized void onFailure(Throwable throwable) {
        this.isSubmitted = false;
        if (this.isClosed.get()) {
            LOGGER.info("onFailure in pipe config node subtask, ignored because pipe is dropped.", throwable);
            this.releaseLastEvent(false);
            return;
        }
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {}({}), because of {}. Will retry forever until success.", new Object[]{this.taskID, ((Object)((Object)this)).getClass().getSimpleName(), throwable.getMessage(), throwable});
        }
        this.retryCount.incrementAndGet();
        LOGGER.warn("Retry executing subtask {}({}), retry count {}", new Object[]{this.taskID, ((Object)((Object)this)).getClass().getSimpleName(), this.retryCount.get()});
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when retrying to execute subtask {}({})", (Object)this.taskID, (Object)((Object)((Object)this)).getClass().getSimpleName());
            Thread.currentThread().interrupt();
        }
        this.submitSelf();
    }

    public void submitSelf() {
        if (this.shouldStopSubmittingSelf.get() || this.isSubmitted) {
            return;
        }
        this.callbackDecoratingLock.markAsDecorating();
        try {
            ListenableFuture nextFuture = this.subtaskWorkerThreadPoolExecutor.submit((Callable)((Object)this));
            Futures.addCallback((ListenableFuture)nextFuture, (FutureCallback)this, (Executor)this.subtaskCallbackListeningExecutor);
            this.isSubmitted = true;
        }
        finally {
            this.callbackDecoratingLock.markAsDecorated();
        }
    }

    public void close() {
        this.isClosed.set(true);
        try {
            this.extractor.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeExtractor.", (Throwable)e);
        }
        try {
            this.processor.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeProcessor.", (Throwable)e);
        }
        try {
            this.connector.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeConnector.", (Throwable)e);
        }
        finally {
            super.close();
        }
    }

    protected synchronized void releaseLastEvent(boolean shouldReport) {
        if (this.lastEvent != null) {
            this.lastEvent = null;
        }
    }
}

