/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.CountTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollSpecificRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.response.partition.CountTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetRegionIdResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetSeriesSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.RegionGroupExtensionPolicy;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainType;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final RegionGroupExtensionPolicy SCHEMA_REGION_GROUP_EXTENSION_POLICY = CONF.getSchemaRegionGroupExtensionPolicy();
    private static final RegionGroupExtensionPolicy DATA_REGION_GROUP_EXTENSION_POLICY = CONF.getDataRegionGroupExtensionPolicy();
    private final IManager configManager;
    private final PartitionInfo partitionInfo;
    private SeriesPartitionExecutor executor;
    private static final String CONSENSUS_READ_ERROR = "Failed in the read API executing the consensus layer due to: ";
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";
    private final Object scheduleMonitor = new Object();
    private static final int REGION_MAINTAINER_WORK_INTERVAL = 10;
    private final ScheduledExecutorService regionMaintainer;
    private Future<?> currentRegionMaintainerFuture;

    public PartitionManager(IManager configManager, PartitionInfo partitionInfo) {
        this.configManager = configManager;
        this.partitionInfo = partitionInfo;
        this.regionMaintainer = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_REGION_MAINTAINER.getName());
        this.setSeriesPartitionExecutor();
    }

    private void setSeriesPartitionExecutor() {
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)CONF.getSeriesPartitionExecutorClass(), (int)CONF.getSeriesSlotNum());
    }

    public SchemaPartitionResp getSchemaPartition(GetSchemaPartitionPlan req) {
        try {
            return (SchemaPartitionResp)this.getConsensusManager().read(req);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new SchemaPartitionResp(res, false, Collections.emptyMap());
        }
    }

    public DataPartitionResp getDataPartition(GetDataPartitionPlan req) {
        try {
            return (DataPartitionResp)this.getConsensusManager().read(req);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new DataPartitionResp(res, false, Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartitionResp getOrCreateSchemaPartition(GetOrCreateSchemaPartitionPlan req) {
        for (String string : req.getPartitionSlotsMap().keySet()) {
            if (this.isDatabaseExist(string)) continue;
            return new SchemaPartitionResp(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage(String.format("Create SchemaPartition failed because the database: %s is not exists", string)), false, null);
        }
        SchemaPartitionResp resp = this.getSchemaPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, SchemaPartitionTable> assignedSchemaPartition;
            resp = this.getSchemaPartition(req);
            if (resp.isAllPartitionsExist()) {
                return resp;
            }
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedSchemaPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedSchemaPartitionSlotsMap.forEach((storageGroup, unassignedSchemaPartitionSlots) -> unassignedSchemaPartitionSlotsCountMap.put((String)storageGroup, unassignedSchemaPartitionSlots.size()));
            TSStatus status = this.extendRegionGroupIfNecessary(unassignedSchemaPartitionSlotsCountMap, TConsensusGroupType.SchemaRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedSchemaPartition = this.getLoadManager().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
            }
            catch (NoAvailableRegionGroupException e) {
                status = this.getConsensusManager().confirmLeader();
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    resp.setStatus(status);
                    return resp;
                }
                LOGGER.error("Create SchemaPartition failed because: ", (Throwable)e);
                resp.setStatus(new TSStatus(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateSchemaPartitionPlan createPlan = new CreateSchemaPartitionPlan();
            createPlan.setAssignedSchemaPartition(assignedSchemaPartition);
            status = this.consensusWritePartitionResult(createPlan);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
        }
        resp = this.getSchemaPartition(req);
        if (!resp.isAllPartitionsExist()) {
            AtomicInteger atomicInteger = new AtomicInteger();
            req.getPartitionSlotsMap().forEach((database, partitionSlots) -> totalSlotNum.addAndGet(partitionSlots.size()));
            AtomicInteger unassignedSlotNum = new AtomicInteger();
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            unassignedSchemaPartitionSlotsMap.forEach((database, unassignedSchemaPartitionSlots) -> unassignedSlotNum.addAndGet(unassignedSchemaPartitionSlots.size()));
            String errMsg = String.format("Lacked %d/%d SchemaPartition allocation result in the response of getOrCreateSchemaPartition method", unassignedSlotNum.get(), atomicInteger.get());
            LOGGER.error(errMsg);
            resp.setStatus(new TSStatus(TSStatusCode.LACK_PARTITION_ALLOCATION.getStatusCode()).setMessage(errMsg));
            return resp;
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartitionResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan req) {
        for (String string : req.getPartitionSlotsMap().keySet()) {
            if (this.isDatabaseExist(string)) continue;
            return new DataPartitionResp(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage(String.format("Create DataPartition failed because the database: %s is not exists", string)), false, null);
        }
        DataPartitionResp resp = this.getDataPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, DataPartitionTable> assignedDataPartition;
            resp = this.getDataPartition(req);
            if (resp.isAllPartitionsExist()) {
                return resp;
            }
            Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedDataPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedDataPartitionSlotsMap.forEach((storageGroup, unassignedDataPartitionSlots) -> unassignedDataPartitionSlotsCountMap.put((String)storageGroup, unassignedDataPartitionSlots.size()));
            TSStatus status = this.extendRegionGroupIfNecessary(unassignedDataPartitionSlotsCountMap, TConsensusGroupType.DataRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedDataPartition = this.getLoadManager().allocateDataPartition(unassignedDataPartitionSlotsMap);
            }
            catch (NoAvailableRegionGroupException e) {
                status = this.getConsensusManager().confirmLeader();
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    resp.setStatus(status);
                    return resp;
                }
                LOGGER.error("Create DataPartition failed because: ", (Throwable)e);
                resp.setStatus(new TSStatus(TSStatusCode.NO_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateDataPartitionPlan createPlan = new CreateDataPartitionPlan();
            createPlan.setAssignedDataPartition(assignedDataPartition);
            status = this.consensusWritePartitionResult(createPlan);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
        }
        resp = this.getDataPartition(req);
        if (!resp.isAllPartitionsExist()) {
            AtomicInteger atomicInteger = new AtomicInteger();
            req.getPartitionSlotsMap().forEach((database, partitionSlots) -> partitionSlots.forEach((seriesPartitionSlot, timeSlotList) -> totalSlotNum.addAndGet(timeSlotList.getTimePartitionSlots().size())));
            AtomicInteger unassignedSlotNum = new AtomicInteger();
            Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            unassignedDataPartitionSlotsMap.forEach((database, unassignedDataPartitionSlots) -> unassignedDataPartitionSlots.forEach((seriesPartitionSlot, timeSlotList) -> unassignedSlotNum.addAndGet(timeSlotList.getTimePartitionSlots().size())));
            String errMsg = String.format("Lacked %d/%d DataPartition allocation result in the response of getOrCreateDataPartition method", unassignedSlotNum.get(), atomicInteger.get());
            LOGGER.error(errMsg);
            resp.setStatus(new TSStatus(TSStatusCode.LACK_PARTITION_ALLOCATION.getStatusCode()).setMessage(errMsg));
            return resp;
        }
        return resp;
    }

    private TSStatus consensusWritePartitionResult(ConfigPhysicalPlan plan) {
        TSStatus status = this.getConsensusManager().confirmLeader();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        try {
            return this.getConsensusManager().write(plan);
        }
        catch (ConsensusException e) {
            LOGGER.error("Write DataPartition allocation result failed because: {}", (Object)status);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    private TSStatus extendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) {
        TSStatus result = new TSStatus();
        try {
            if (TConsensusGroupType.SchemaRegion.equals((Object)consensusGroupType)) {
                switch (SCHEMA_REGION_GROUP_EXTENSION_POLICY) {
                    case CUSTOM: {
                        return this.customExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
                    }
                }
                return this.autoExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
            }
            switch (DATA_REGION_GROUP_EXTENSION_POLICY) {
                case CUSTOM: {
                    return this.customExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
                }
            }
            return this.autoExtendRegionGroupIfNecessary(unassignedPartitionSlotsCountMap, consensusGroupType);
        }
        catch (NotEnoughDataNodeException e) {
            LOGGER.error(e.getMessage());
            result.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
            result.setMessage(e.getMessage());
        }
        catch (DatabaseNotExistsException e) {
            LOGGER.error(e.getMessage());
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private TSStatus customExtendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) throws DatabaseNotExistsException, NotEnoughDataNodeException {
        ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
            String database = entry.getKey();
            int minRegionGroupNum = this.getClusterSchemaManager().getMinRegionGroupNum(database, consensusGroupType);
            int allocatedRegionGroupCount = this.partitionInfo.getRegionGroupCount(database, consensusGroupType);
            if (allocatedRegionGroupCount >= minRegionGroupNum) continue;
            allotmentMap.put(database, minRegionGroupNum - allocatedRegionGroupCount);
        }
        return this.generateAndAllocateRegionGroups(allotmentMap, consensusGroupType);
    }

    private TSStatus autoExtendRegionGroupIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
            int delta;
            String database = entry.getKey();
            int unassignedPartitionSlotsCount = entry.getValue();
            float allocatedRegionGroupCount = this.partitionInfo.getRegionGroupCount(database, consensusGroupType);
            float slotCount = (float)this.partitionInfo.getAssignedSeriesPartitionSlotsCount(database) + (float)unassignedPartitionSlotsCount;
            float maxRegionGroupNum = this.getClusterSchemaManager().getMaxRegionGroupNum(database, consensusGroupType);
            float maxSlotCount = CONF.getSeriesSlotNum();
            int minRegionGroupNum = this.getClusterSchemaManager().getMinRegionGroupNum(database, consensusGroupType);
            if (allocatedRegionGroupCount < (float)minRegionGroupNum && slotCount <= maxSlotCount / maxRegionGroupNum * (float)minRegionGroupNum) {
                delta = (int)Math.min((float)unassignedPartitionSlotsCount, (float)minRegionGroupNum - allocatedRegionGroupCount);
                allotmentMap.put(database, delta);
                continue;
            }
            if (allocatedRegionGroupCount < maxRegionGroupNum && slotCount / allocatedRegionGroupCount > maxSlotCount / maxRegionGroupNum) {
                delta = Math.min((int)(maxRegionGroupNum - allocatedRegionGroupCount), Math.max(1, (int)Math.ceil(slotCount * maxRegionGroupNum / maxSlotCount - allocatedRegionGroupCount)));
                allotmentMap.put(database, delta);
                continue;
            }
            if (allocatedRegionGroupCount != (float)this.filterRegionGroupThroughStatus(database, RegionGroupStatus.Disabled).size() || !(allocatedRegionGroupCount < maxRegionGroupNum)) continue;
            allotmentMap.put(database, 1);
        }
        return this.generateAndAllocateRegionGroups(allotmentMap, consensusGroupType);
    }

    private TSStatus generateAndAllocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        if (!allotmentMap.isEmpty()) {
            CreateRegionGroupsPlan createRegionGroupsPlan = this.getLoadManager().allocateRegionGroups(allotmentMap, consensusGroupType);
            LOGGER.info("[CreateRegionGroups] Starting to create the following RegionGroups:");
            createRegionGroupsPlan.planLog(LOGGER);
            return this.getProcedureManager().createRegionGroups(consensusGroupType, createRegionGroupsPlan);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    public TConsensusGroupId getSuccessorDataPartition(String database, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        return this.partitionInfo.getSuccessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
    }

    public TConsensusGroupId getPredecessorDataPartition(String database, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        return this.partitionInfo.getPredecessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
    }

    public Set<TDataNodeLocation> getDatabaseRelatedDataNodes(String database, TConsensusGroupType type) {
        return this.partitionInfo.getDatabaseRelatedDataNodes(database, type);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getAllReplicaSetsMap(TConsensusGroupType type) {
        return this.partitionInfo.getAllReplicaSets(type).stream().collect(Collectors.toMap(TRegionReplicaSet::getRegionId, regionReplicaSet -> regionReplicaSet));
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.partitionInfo.getAllReplicaSets();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(TConsensusGroupType type) {
        return this.partitionInfo.getAllReplicaSets(type);
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String database) {
        return this.partitionInfo.getAllReplicaSets(database);
    }

    public List<TRegionReplicaSet> getAllReplicaSets(int dataNodeId) {
        return this.partitionInfo.getAllReplicaSets(dataNodeId);
    }

    public List<TRegionReplicaSet> getReplicaSets(String database, List<TConsensusGroupId> regionGroupIds) {
        return this.partitionInfo.getReplicaSets(database, regionGroupIds);
    }

    public int getRegionCount(int dataNodeId, TConsensusGroupType type) {
        return this.partitionInfo.getRegionCount(dataNodeId, type);
    }

    public int countDataNodeScatterWidth(int dataNodeId, TConsensusGroupType type) {
        int clusterNodeCount = this.getNodeManager().getRegisteredNodeCount();
        return this.partitionInfo.countDataNodeScatterWidth(dataNodeId, type, clusterNodeCount);
    }

    public int getRegionGroupCount(String database, TConsensusGroupType type) throws DatabaseNotExistsException {
        return this.partitionInfo.getRegionGroupCount(database, type);
    }

    public List<TConsensusGroupId> getAllRegionGroupIds(String database, TConsensusGroupType type) throws DatabaseNotExistsException {
        return this.partitionInfo.getAllRegionGroupIds(database, type);
    }

    public boolean isDatabaseExist(String database) {
        return this.partitionInfo.isDatabaseExisted(database);
    }

    public List<PartialPath> filterUnExistDatabases(List<PartialPath> databases) {
        ArrayList<PartialPath> unExistDatabases = new ArrayList<PartialPath>();
        if (databases == null) {
            return unExistDatabases;
        }
        for (PartialPath database : databases) {
            if (this.isDatabaseExist(database.getFullPath())) continue;
            unExistDatabases.add(database);
        }
        return unExistDatabases;
    }

    public int getAssignedSeriesPartitionSlotsCount(String database) {
        return this.partitionInfo.getAssignedSeriesPartitionSlotsCount(database);
    }

    public long getAssignedTimePartitionSlotsCount(String database) {
        return this.partitionInfo.getAssignedTimePartitionSlotsCount(database);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionGroupSlotsCounter(String database, TConsensusGroupType type) throws NoAvailableRegionGroupException {
        List<Pair<Long, TConsensusGroupId>> regionGroupSlotsCounter = this.partitionInfo.getRegionGroupSlotsCounter(database, type);
        ArrayList<Pair<Long, TConsensusGroupId>> result = new ArrayList<Pair<Long, TConsensusGroupId>>();
        for (Pair<Long, TConsensusGroupId> slotsCounter : regionGroupSlotsCounter) {
            RegionGroupStatus status = this.getLoadManager().getRegionGroupStatus((TConsensusGroupId)slotsCounter.getRight());
            if (RegionGroupStatus.Disabled.equals((Object)status)) continue;
            result.add(slotsCounter);
        }
        if (result.isEmpty()) {
            throw new NoAvailableRegionGroupException(type);
        }
        Map<TConsensusGroupId, RegionGroupStatus> regionGroupStatusMap = this.getLoadManager().getRegionGroupStatus(result.stream().map(Pair::getRight).collect(Collectors.toList()));
        result.sort((o1, o2) -> {
            if ((Long)o1.getLeft() < (Long)o2.getLeft()) {
                return -1;
            }
            if ((Long)o1.getLeft() > (Long)o2.getLeft()) {
                return 1;
            }
            return ((RegionGroupStatus)((Object)((Object)regionGroupStatusMap.get(o1.getRight())))).compare((RegionGroupStatus)((Object)((Object)regionGroupStatusMap.get(o2.getRight()))));
        });
        return result;
    }

    public Set<Integer> getAllSchemaPartition() {
        return this.partitionInfo.getAllSchemaPartition();
    }

    public int generateNextRegionGroupId() {
        return this.partitionInfo.generateNextRegionGroupId();
    }

    public SchemaNodeManagementResp getNodePathsPartition(GetNodePathsPartitionPlan physicalPlan) {
        try {
            return (SchemaNodeManagementResp)this.getConsensusManager().read(physicalPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            SchemaNodeManagementResp resp = new SchemaNodeManagementResp();
            resp.setStatus(res);
            return resp;
        }
    }

    public void preDeleteDatabase(String database, PreDeleteDatabasePlan.PreDeleteType preDeleteType) {
        PreDeleteDatabasePlan preDeleteDatabasePlan = new PreDeleteDatabasePlan(database, preDeleteType);
        try {
            this.getConsensusManager().write(preDeleteDatabasePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
        }
    }

    public boolean isDatabasePreDeleted(String database) {
        return this.partitionInfo.isDatabasePreDeleted(database);
    }

    public TSeriesPartitionSlot getSeriesPartitionSlot(String devicePath) {
        return this.executor.getSeriesPartitionSlot(devicePath);
    }

    public RegionInfoListResp getRegionInfoList(GetRegionInfoListPlan req) {
        try {
            RegionInfoListResp regionInfoListResp = (RegionInfoListResp)this.getConsensusManager().read(req);
            Map<TConsensusGroupId, Integer> allLeadership = this.getLoadManager().getRegionLeaderMap();
            regionInfoListResp.getRegionInfoList().forEach(regionInfo -> {
                regionInfo.setStatus(this.getLoadManager().getRegionStatus(regionInfo.getConsensusGroupId(), regionInfo.getDataNodeId()).getStatus());
                String regionType = regionInfo.getDataNodeId() == allLeadership.getOrDefault(regionInfo.getConsensusGroupId(), -1).intValue() ? RegionRoleType.Leader.toString() : RegionRoleType.Follower.toString();
                regionInfo.setRoleType(regionType);
            });
            return regionInfoListResp;
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            RegionInfoListResp resp = new RegionInfoListResp();
            resp.setStatus(res);
            return resp;
        }
    }

    public boolean isRegionGroupExists(TConsensusGroupId regionGroupId) {
        return this.partitionInfo.isRegionGroupExisted(regionGroupId);
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        try {
            return this.getConsensusManager().write(req);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public GetRegionIdResp getRegionId(TGetRegionIdReq req) {
        GetRegionIdPlan plan = new GetRegionIdPlan(req.getType());
        if (req.isSetDatabase()) {
            plan.setDatabase(req.getDatabase());
        } else {
            plan.setDatabase(this.getClusterSchemaManager().getDatabaseNameByDevice(req.getDevice()));
            plan.setSeriesSlotId(this.executor.getSeriesPartitionSlot(req.getDevice()));
        }
        if (Objects.equals(plan.getDatabase(), "")) {
            return new GetRegionIdResp(RpcUtils.SUCCESS_STATUS, new ArrayList<TConsensusGroupId>());
        }
        if (req.isSetStartTimeSlot()) {
            plan.setStartTimeSlotId(req.getStartTimeSlot());
        } else {
            plan.setStartTimeSlotId(new TTimePartitionSlot(0L));
        }
        if (req.isSetEndTimeSlot()) {
            plan.setEndTimeSlotId(req.getEndTimeSlot());
        } else {
            plan.setEndTimeSlotId(new TTimePartitionSlot(Long.MAX_VALUE));
        }
        try {
            return (GetRegionIdResp)this.getConsensusManager().read(plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new GetRegionIdResp(res, Collections.emptyList());
        }
    }

    public GetTimeSlotListResp getTimeSlotList(TGetTimeSlotListReq req) {
        long startTime = req.isSetStartTime() ? req.getStartTime() : Long.MIN_VALUE;
        long endTime = req.isSetEndTime() ? req.getEndTime() : Long.MAX_VALUE;
        GetTimeSlotListPlan plan = new GetTimeSlotListPlan(startTime, endTime);
        if (req.isSetDatabase()) {
            plan.setDatabase(req.getDatabase());
        } else if (req.isSetDevice()) {
            plan.setDatabase(this.getClusterSchemaManager().getDatabaseNameByDevice(req.getDevice()));
            plan.setSeriesSlotId(this.executor.getSeriesPartitionSlot(req.getDevice()));
            if (Objects.equals(plan.getDatabase(), "")) {
                return new GetTimeSlotListResp(RpcUtils.SUCCESS_STATUS, new ArrayList<TTimePartitionSlot>());
            }
        } else {
            plan.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, (int)req.getRegionId()));
        }
        try {
            return (GetTimeSlotListResp)this.getConsensusManager().read(plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new GetTimeSlotListResp(res, Collections.emptyList());
        }
    }

    public CountTimeSlotListResp countTimeSlotList(TCountTimeSlotListReq req) {
        long startTime = req.isSetStartTime() ? req.getStartTime() : Long.MIN_VALUE;
        long endTime = req.isSetEndTime() ? req.getEndTime() : Long.MAX_VALUE;
        CountTimeSlotListPlan plan = new CountTimeSlotListPlan(startTime, endTime);
        if (req.isSetDatabase()) {
            plan.setDatabase(req.getDatabase());
        } else if (req.isSetDevice()) {
            plan.setDatabase(this.getClusterSchemaManager().getDatabaseNameByDevice(req.getDevice()));
            plan.setSeriesSlotId(this.executor.getSeriesPartitionSlot(req.getDevice()));
            if (Objects.equals(plan.getDatabase(), "")) {
                return new CountTimeSlotListResp(RpcUtils.SUCCESS_STATUS, 0L);
            }
        } else {
            plan.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, (int)req.getRegionId()));
        }
        try {
            return (CountTimeSlotListResp)this.getConsensusManager().read(plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new CountTimeSlotListResp(res, 0L);
        }
    }

    public GetSeriesSlotListResp getSeriesSlotList(TGetSeriesSlotListReq req) {
        GetSeriesSlotListPlan plan = new GetSeriesSlotListPlan(req.getDatabase(), req.getType());
        try {
            return (GetSeriesSlotListResp)this.getConsensusManager().read(plan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new GetSeriesSlotListResp(res, Collections.emptyList());
        }
    }

    public String getRegionStorageGroup(TConsensusGroupId regionId) {
        return this.partitionInfo.getRegionStorageGroup(regionId);
    }

    public void maintainRegionReplicas() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            if (this.getConsensusManager().isLeader()) {
                List<RegionMaintainTask> regionMaintainTaskList = this.partitionInfo.getRegionMaintainEntryList();
                if (regionMaintainTaskList.isEmpty()) {
                    return;
                }
                HashMap<TConsensusGroupId, Queue> regionMaintainTaskMap = new HashMap<TConsensusGroupId, Queue>();
                for (RegionMaintainTask regionMaintainTask : regionMaintainTaskList) {
                    regionMaintainTaskMap.computeIfAbsent(regionMaintainTask.getRegionId(), k -> new LinkedList()).add(regionMaintainTask);
                }
                while (!regionMaintainTaskMap.isEmpty()) {
                    ArrayList<RegionMaintainTask> selectedRegionMaintainTask = new ArrayList<RegionMaintainTask>();
                    Enum currentType = null;
                    for (Map.Entry entry : regionMaintainTaskMap.entrySet()) {
                        RegionMaintainTask regionMaintainTask = (RegionMaintainTask)((Queue)entry.getValue()).peek();
                        if (regionMaintainTask == null) continue;
                        if (currentType == null) {
                            currentType = regionMaintainTask.getType();
                            selectedRegionMaintainTask.add((RegionMaintainTask)((Queue)entry.getValue()).peek());
                            continue;
                        }
                        if (!currentType.equals((Object)regionMaintainTask.getType()) || !currentType.equals((Object)RegionMaintainType.DELETE) && !((TConsensusGroupId)entry.getKey()).getType().equals((Object)((RegionMaintainTask)selectedRegionMaintainTask.get(0)).getRegionId().getType())) continue;
                        selectedRegionMaintainTask.add((RegionMaintainTask)((Queue)entry.getValue()).peek());
                    }
                    if (selectedRegionMaintainTask.isEmpty()) break;
                    HashSet<TConsensusGroupId> successfulTask = new HashSet<TConsensusGroupId>();
                    block1 : switch (1.$SwitchMap$org$apache$iotdb$confignode$persistence$partition$maintainer$RegionMaintainType[currentType.ordinal()]) {
                        case 1: {
                            switch (((RegionMaintainTask)selectedRegionMaintainTask.get(0)).getRegionId().getType()) {
                                case SchemaRegion: {
                                    AsyncClientHandler createSchemaRegionHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_SCHEMA_REGION);
                                    for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                        RegionCreateTask regionCreateTask = (RegionCreateTask)regionMaintainTask;
                                        LOGGER.info("Start to create Region: {} on DataNode: {}", (Object)regionCreateTask.getRegionReplicaSet().getRegionId(), (Object)regionCreateTask.getTargetDataNode());
                                        createSchemaRegionHandler.putRequest(regionCreateTask.getRegionId().getId(), new TCreateSchemaRegionReq(regionCreateTask.getRegionReplicaSet(), regionCreateTask.getStorageGroup()));
                                        createSchemaRegionHandler.putDataNodeLocation(regionCreateTask.getRegionId().getId(), regionCreateTask.getTargetDataNode());
                                    }
                                    AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(createSchemaRegionHandler);
                                    for (Map.Entry entry : createSchemaRegionHandler.getResponseMap().entrySet()) {
                                        if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                        successfulTask.add(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, entry.getKey().intValue()));
                                    }
                                    break block1;
                                }
                                case DataRegion: {
                                    AsyncClientHandler createDataRegionHandler = new AsyncClientHandler(DataNodeRequestType.CREATE_DATA_REGION);
                                    for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                        RegionCreateTask dataRegionCreateTask = (RegionCreateTask)regionMaintainTask;
                                        LOGGER.info("Start to create Region: {} on DataNode: {}", (Object)dataRegionCreateTask.getRegionReplicaSet().getRegionId(), (Object)dataRegionCreateTask.getTargetDataNode());
                                        createDataRegionHandler.putRequest(dataRegionCreateTask.getRegionId().getId(), new TCreateDataRegionReq(dataRegionCreateTask.getRegionReplicaSet(), dataRegionCreateTask.getStorageGroup()).setTtl(dataRegionCreateTask.getTTL()));
                                        createDataRegionHandler.putDataNodeLocation(dataRegionCreateTask.getRegionId().getId(), dataRegionCreateTask.getTargetDataNode());
                                    }
                                    AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(createDataRegionHandler);
                                    for (Map.Entry entry : createDataRegionHandler.getResponseMap().entrySet()) {
                                        if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                        successfulTask.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, ((Integer)entry.getKey()).intValue()));
                                    }
                                }
                            }
                            break;
                        }
                        case 2: {
                            AsyncClientHandler deleteRegionHandler = new AsyncClientHandler(DataNodeRequestType.DELETE_REGION);
                            HashMap<Integer, TConsensusGroupId> regionIdMap = new HashMap<Integer, TConsensusGroupId>();
                            for (RegionMaintainTask regionMaintainTask : selectedRegionMaintainTask) {
                                RegionDeleteTask regionDeleteTask = (RegionDeleteTask)regionMaintainTask;
                                LOGGER.info("Start to delete Region: {} on DataNode: {}", (Object)regionDeleteTask.getRegionId(), (Object)regionDeleteTask.getTargetDataNode());
                                deleteRegionHandler.putRequest(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getRegionId());
                                deleteRegionHandler.putDataNodeLocation(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getTargetDataNode());
                                regionIdMap.put(regionDeleteTask.getRegionId().getId(), regionDeleteTask.getRegionId());
                            }
                            long startTime = System.currentTimeMillis();
                            AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(deleteRegionHandler);
                            LOGGER.info("Deleting regions costs {}ms", (Object)(System.currentTimeMillis() - startTime));
                            for (Map.Entry entry : deleteRegionHandler.getResponseMap().entrySet()) {
                                if (((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                                successfulTask.add((TConsensusGroupId)regionIdMap.get(entry.getKey()));
                            }
                            break;
                        }
                    }
                    if (successfulTask.isEmpty()) break;
                    for (TConsensusGroupId regionId : successfulTask) {
                        regionMaintainTaskMap.compute(regionId, (k, v) -> {
                            if (v == null) {
                                throw new IllegalStateException();
                            }
                            v.poll();
                            if (v.isEmpty()) {
                                return null;
                            }
                            return v;
                        });
                    }
                    try {
                        this.getConsensusManager().write(new PollSpecificRegionMaintainTaskPlan(successfulTask));
                    }
                    catch (ConsensusException e) {
                        LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
                    }
                    if (successfulTask.size() >= selectedRegionMaintainTask.size()) continue;
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture == null) {
                this.currentRegionMaintainerFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.regionMaintainer, this::maintainRegionReplicas, (long)0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.info("RegionCleaner is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture != null) {
                this.currentRegionMaintainerFuture.cancel(false);
                this.currentRegionMaintainerFuture = null;
                LOGGER.info("RegionCleaner is stopped successfully.");
            }
        }
    }

    public List<TRegionReplicaSet> filterRegionGroupThroughStatus(String database, RegionGroupStatus ... status) {
        List<TConsensusGroupId> matchedRegionGroups = this.getLoadManager().filterRegionGroupThroughStatus(status);
        return this.getReplicaSets(database, matchedRegionGroups);
    }

    public void getSchemaRegionIds(List<String> databases, Map<String, List<Integer>> schemaRegionIds) {
        this.partitionInfo.getSchemaRegionIds(databases, schemaRegionIds);
    }

    public void getDataRegionIds(List<String> databases, Map<String, List<Integer>> dataRegionIds) {
        this.partitionInfo.getDataRegionIds(databases, dataRegionIds);
    }

    public Optional<TConsensusGroupType> getRegionType(int regionId) {
        return this.partitionInfo.getRegionType(regionId);
    }

    public Map<TSeriesPartitionSlot, TConsensusGroupId> getLastDataAllotTable(String database) {
        return this.partitionInfo.getLastDataAllotTable(database);
    }

    public ScheduledExecutorService getRegionMaintainer() {
        return this.regionMaintainer;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private ProcedureManager getProcedureManager() {
        return this.configManager.getProcedureManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }
}

