/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeDuration
implements Serializable {
    public final int monthDuration;
    public final long nonMonthDuration;

    public TimeDuration(int monthDuration, long nonMonthDuration) {
        this.monthDuration = monthDuration;
        this.nonMonthDuration = nonMonthDuration;
    }

    public boolean containsMonth() {
        return this.monthDuration != 0;
    }

    public long getTotalDuration(TimeUnit currPrecision) {
        return currPrecision.convert((long)(this.monthDuration * 30) * 86400000L, TimeUnit.MILLISECONDS) + this.nonMonthDuration;
    }

    public long getMaxTotalDuration(TimeUnit currPrecision) {
        return currPrecision.convert((long)(this.monthDuration * 31) * 86400000L, TimeUnit.MILLISECONDS) + this.nonMonthDuration;
    }

    public boolean isGreaterThan(TimeDuration right) {
        if (this.monthDuration > right.monthDuration) {
            return true;
        }
        if (this.monthDuration == right.monthDuration) {
            return this.nonMonthDuration > right.nonMonthDuration;
        }
        return false;
    }

    public TimeDuration merge(TimeDuration other) {
        return new TimeDuration(this.monthDuration + other.monthDuration, this.nonMonthDuration + other.nonMonthDuration);
    }

    public TimeDuration multiple(long times) {
        return new TimeDuration((int)((long)this.monthDuration * times), this.nonMonthDuration * times);
    }

    public long getMinTotalDuration(TimeUnit currPrecision) {
        return currPrecision.convert((long)(this.monthDuration * 28) * 86400000L, TimeUnit.MILLISECONDS) + this.nonMonthDuration;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write(this.monthDuration, buffer);
        ReadWriteIOUtils.write(this.nonMonthDuration, buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.monthDuration, (OutputStream)stream);
        ReadWriteIOUtils.write(this.nonMonthDuration, (OutputStream)stream);
    }

    public static TimeDuration deserialize(ByteBuffer buffer) {
        return new TimeDuration(ReadWriteIOUtils.readInt(buffer), ReadWriteIOUtils.readLong(buffer));
    }

    public static long[] getConsecutiveTimesIntervalByMonth(long startTime, TimeDuration duration, int length, TimeZone timeZone, TimeUnit currPrecision) {
        long[] result = new long[length];
        result[0] = startTime;
        for (int i = 1; i < length; ++i) {
            result[i] = TimeDuration.getStartTime(startTime, duration.multiple(i), currPrecision, timeZone.toZoneId());
        }
        return result;
    }

    public static long calcPositiveIntervalByMonth(long startTime, TimeDuration duration, TimeZone timeZone, TimeUnit currPrecision) {
        return TimeDuration.getStartTime(startTime, duration, currPrecision, timeZone.toZoneId());
    }

    private static long getStartTime(long startTime, TimeDuration duration, TimeUnit currPrecision, ZoneId zoneId) {
        long coarserThanMsPart = TimeDuration.getCoarserThanMsPart(startTime, currPrecision);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(coarserThanMsPart), zoneId);
        localDateTime = localDateTime.plusMonths(duration.monthDuration);
        return currPrecision.convert(localDateTime.atZone(zoneId).toInstant().toEpochMilli(), TimeUnit.MILLISECONDS) + TimeDuration.getFinerThanMsPart(startTime, currPrecision) + duration.nonMonthDuration;
    }

    private static long getCoarserThanMsPart(long time, TimeUnit currPrecision) {
        return TimeUnit.MILLISECONDS.convert(time, currPrecision);
    }

    private static long getFinerThanMsPart(long time, TimeUnit currPrecision) {
        switch (currPrecision) {
            case MILLISECONDS: {
                return 0L;
            }
            case MICROSECONDS: {
                return time % 1000L;
            }
            case NANOSECONDS: {
                return time % 1000000L;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDuration that = (TimeDuration)o;
        return this.monthDuration == that.monthDuration && this.nonMonthDuration == that.nonMonthDuration;
    }

    public int hashCode() {
        return Objects.hash(this.monthDuration, this.nonMonthDuration);
    }

    public String toString() {
        return "TimeDuration{" + (this.monthDuration > 0 ? this.monthDuration + "mo, " : "") + (this.nonMonthDuration > 0L ? Long.valueOf(this.nonMonthDuration) : "") + '}';
    }
}

