/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.string;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;

public class UDTFRegexReplace
implements UDTF {
    private String regex;
    private Pattern pattern;
    private String replace;
    private int limit;
    private int offset;
    private boolean reverse;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(regex -> ((String)regex).length() > 0, "regex should not be empty", (Object)validator.getParameters().getString("regex")).validate(limit -> (Integer)limit >= -1, "limit has to be -1 for replacing all matches or non-negative integers for limited times.", (Object)validator.getParameters().getIntOrDefault("limit", -1)).validate(offset -> (Integer)offset >= 0, "offset has to be non-negative to skip first several matches.", (Object)validator.getParameters().getIntOrDefault("offset", 0));
    }

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        this.regex = udfParameters.getString("regex");
        this.pattern = Pattern.compile(this.regex);
        this.replace = udfParameters.getString("replace");
        this.limit = udfParameters.getIntOrDefault("limit", -1);
        this.offset = udfParameters.getIntOrDefault("offset", 0);
        this.reverse = udfParameters.getBooleanOrDefault("reverse", false);
        udtfConfigurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        String origin = row.getString(0);
        Matcher matcher = this.pattern.matcher(origin);
        String result = this.getResult(origin, matcher);
        collector.putString(row.getTime(), result);
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        String origin = row.getString(0);
        Matcher matcher = this.pattern.matcher(origin);
        return this.getResult(origin, matcher);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String origin = inputs[i].toString();
            Matcher matcher = this.pattern.matcher(origin);
            builder.writeBinary(new Binary(this.getResult(origin, matcher).getBytes()));
        }
    }

    private String getResult(String origin, Matcher matcher) {
        String result;
        if (this.reverse) {
            IntArrayList endIndexList = new IntArrayList();
            while (matcher.find()) {
                endIndexList.add(matcher.end());
            }
            String suffix = endIndexList.size() < this.offset + 1 ? origin : origin.substring(endIndexList.get(endIndexList.size() - this.offset - 1));
            String prefix = "";
            if (this.limit != -1 && endIndexList.size() >= this.limit + this.offset + 1) {
                prefix = origin.substring(0, endIndexList.get(endIndexList.size() - this.limit - this.offset - 1));
            }
            result = prefix.concat(origin.substring(prefix.length(), origin.length() - suffix.length()).replaceAll(this.regex, this.replace)).concat(suffix);
        } else {
            IntArrayList fromIndexList = new IntArrayList();
            while (matcher.find() && fromIndexList.size() < this.limit + this.offset + 2) {
                fromIndexList.add(matcher.start());
            }
            String prefix = origin;
            if (fromIndexList.size() >= this.offset + 1) {
                prefix = origin.substring(0, fromIndexList.get(this.offset));
            }
            String suffix = "";
            if (this.limit != -1 && fromIndexList.size() >= this.limit + this.offset + 1) {
                suffix = origin.substring(fromIndexList.get(this.limit + this.offset));
            }
            result = prefix.concat(origin.substring(prefix.length(), origin.length() - suffix.length()).replaceAll(this.regex, this.replace)).concat(suffix);
        }
        return result;
    }
}

