/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.observability;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import reactor.netty.observability.ReactorNettyHandlerContext;

public final class ReactorNettyTimerObservationHandler
implements MeterObservationHandler<Observation.Context> {
    final MeterRegistry meterRegistry;

    public ReactorNettyTimerObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onStart(Observation.Context context) {
        Timer.Sample sample = Timer.start(this.meterRegistry);
        context.put(Timer.Sample.class, sample);
    }

    @Override
    public void onStop(Observation.Context context) {
        ReactorNettyHandlerContext reactorNettyContext = (ReactorNettyHandlerContext)((Object)context);
        Timer timer = reactorNettyContext.getTimer();
        if (timer != null) {
            Timer.Sample sample = (Timer.Sample)context.getRequired(Timer.Sample.class);
            sample.stop(timer);
        }
    }

    @Override
    public boolean supportsContext(Observation.Context context) {
        return context instanceof ReactorNettyHandlerContext;
    }
}

