/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSPath;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSUtils {
    private static final Logger logger = LoggerFactory.getLogger(FSUtils.class);
    private static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final FSType[] fsTypes = new FSType[]{FSType.OBJECT_STORAGE, FSType.HDFS};
    public static final int PATH_FROM_SEQUENCE_LEVEL = 5;
    public static final int PATH_FROM_DATABASE_LEVEL = 4;
    public static final String[] fsPrefix = new String[]{"os://", "hdfs://"};
    public static final String OS_FILE_SEPARATOR = "/";
    private static final String[] fsFileClassName = new String[]{config.getObjectStorageFile(), config.getHdfsFile()};
    private static final boolean[] isSupported = new boolean[fsTypes.length];
    private static final Class<?>[] fsFileClass = new Class[fsTypes.length];

    private FSUtils() {
    }

    public static synchronized void reload() {
        FSUtils.fsFileClassName[0] = config.getObjectStorageFile();
        FSUtils.fsFileClassName[1] = config.getHdfsFile();
        for (FSType fsType : config.getTSFileStorageFs()) {
            if (fsType == FSType.OBJECT_STORAGE) {
                FSUtils.isSupported[0] = true;
                continue;
            }
            if (fsType != FSType.HDFS) continue;
            FSUtils.isSupported[1] = true;
        }
        for (int i = 0; i < fsTypes.length; ++i) {
            if (!isSupported[i]) continue;
            try {
                FSUtils.fsFileClass[i] = Class.forName(fsFileClassName[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error("Failed to get " + fsTypes[i].name() + " file system. Please check your dependency of " + fsTypes[i].name() + " module.", e);
            }
        }
    }

    public static FSType getFSType(File file) {
        for (int i = 0; i < fsTypes.length; ++i) {
            if (fsFileClass[i] == null || !fsFileClass[i].isInstance(file)) continue;
            return fsTypes[i];
        }
        return FSType.LOCAL;
    }

    public static FSType getFSType(String fsPath) {
        for (int i = 0; i < fsTypes.length; ++i) {
            if (!fsPath.startsWith(fsPrefix[i])) continue;
            return fsTypes[i];
        }
        return FSType.LOCAL;
    }

    public static String getPath(String fsPath) {
        for (int i = 0; i < fsTypes.length; ++i) {
            if (!fsPath.startsWith(fsPrefix[i])) continue;
            return fsPath.substring(fsPrefix[i].length());
        }
        return fsPath;
    }

    public static FSPath parse(String fsPath) {
        FSType type = FSType.LOCAL;
        String path = fsPath;
        for (int i = 0; i < fsTypes.length; ++i) {
            if (!fsPath.startsWith(fsPrefix[i])) continue;
            type = fsTypes[i];
            break;
        }
        return new FSPath(type, path);
    }

    public static String getOSDefaultPath(String bucket, int dataNodeId) {
        return new FSPath(FSType.OBJECT_STORAGE, fsPrefix[0] + bucket + OS_FILE_SEPARATOR + dataNodeId).getPath();
    }

    public static FSPath parseLocalTsFile2OSFile(File localFile, String bucket, int dataNodeId) throws IOException {
        return new FSPath(FSType.OBJECT_STORAGE, fsPrefix[0] + bucket + OS_FILE_SEPARATOR + dataNodeId + OS_FILE_SEPARATOR + FSUtils.getLocalTsFileShortPath(localFile, 5));
    }

    public static String getLocalTsFileShortPath(File localTsFile, int level) throws IOException {
        String[] filePathSplits = FilePathUtils.splitTsFilePath(localTsFile.getCanonicalPath());
        return String.join((CharSequence)OS_FILE_SEPARATOR, Arrays.copyOfRange(filePathSplits, filePathSplits.length - level, filePathSplits.length));
    }

    public static boolean isLocal(String fsPath) {
        return FSUtils.getFSType(fsPath) == FSType.LOCAL;
    }

    public static boolean isLocal(File file) {
        return FSUtils.getFSType(file) == FSType.LOCAL;
    }

    static {
        FSUtils.reload();
    }
}

