/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.parser;

import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.db.qp.sql.PathParser;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.apache.iotdb.tsfile.exception.PathParseException;
import org.apache.iotdb.tsfile.read.common.parser.PathParseError;
import org.apache.iotdb.tsfile.read.common.parser.PathVisitor;

public class PathNodesGenerator {
    private static final PathVisitor pathVisitor = new PathVisitor();

    private PathNodesGenerator() {
    }

    public static String[] splitPathToNodes(String path) throws PathParseException {
        try {
            return PathNodesGenerator.invokeParser(path);
        }
        catch (ParseCancellationException e) {
            throw new PathParseException(path);
        }
    }

    public static void checkPath(String path) throws PathParseException {
        try {
            PathNodesGenerator.invokeParser(path);
        }
        catch (ParseCancellationException e) {
            throw new PathParseException(path);
        }
    }

    private static String[] invokeParser(String path) {
        PathParser.PathContext tree;
        CodePointCharStream charStream1 = CharStreams.fromString(path);
        SqlLexer lexer1 = new SqlLexer(charStream1);
        lexer1.removeErrorListeners();
        lexer1.addErrorListener(PathParseError.INSTANCE);
        CommonTokenStream tokens1 = new CommonTokenStream(lexer1);
        PathParser pathParser1 = new PathParser(tokens1);
        ((ParserATNSimulator)pathParser1.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        pathParser1.removeErrorListeners();
        pathParser1.addErrorListener(PathParseError.INSTANCE);
        try {
            tree = pathParser1.path();
        }
        catch (Exception ex) {
            CodePointCharStream charStream2 = CharStreams.fromString(path);
            SqlLexer lexer2 = new SqlLexer(charStream2);
            lexer2.removeErrorListeners();
            lexer2.addErrorListener(PathParseError.INSTANCE);
            CommonTokenStream tokens2 = new CommonTokenStream(lexer2);
            PathParser pathParser2 = new PathParser(tokens2);
            ((ParserATNSimulator)pathParser2.getInterpreter()).setPredictionMode(PredictionMode.LL);
            pathParser2.removeErrorListeners();
            pathParser2.addErrorListener(PathParseError.INSTANCE);
            tree = pathParser2.path();
        }
        return (String[])pathVisitor.visit(tree);
    }
}

