/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class BinaryColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryColumnBuilder.class).instanceSize();
    private final ColumnBuilderStatus columnBuilderStatus;
    public static final BinaryColumn NULL_VALUE_BLOCK = new BinaryColumn(0, 1, new boolean[]{true}, new Binary[1]);
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private Binary[] values = new Binary[0];
    private long arraysRetainedSizeInBytes;

    public BinaryColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.columnBuilderStatus = columnBuilderStatus;
        this.updateArraysDataSize();
    }

    @Override
    public ColumnBuilder writeBinary(Binary value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        return this;
    }

    @Override
    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Binary) {
            this.writeBinary((Binary)value);
            return this;
        }
        throw new UnSupportedDataTypeException("BinaryColumn only support Binary data type");
    }

    @Override
    public ColumnBuilder write(Column column, int index) {
        return this.writeBinary(column.getBinary(index));
    }

    @Override
    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeBinary(value.getBinary());
    }

    @Override
    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        return this;
    }

    @Override
    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new BinaryColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.arraysRetainedSizeInBytes;
        if (this.columnBuilderStatus != null) {
            size += (long)ColumnBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new BinaryColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.values);
    }
}

