/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryEncoder
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryEncoder.class);
    private HashMap<Binary, Integer> entryIndex = new HashMap();
    private List<Binary> indexEntry = new ArrayList<Binary>();
    private IntRleEncoder valuesEncoder = new IntRleEncoder();
    private long mapSize = 0L;

    public DictionaryEncoder() {
        super(TSEncoding.DICTIONARY);
    }

    @Override
    public void encode(Binary value, ByteArrayOutputStream out) {
        this.entryIndex.computeIfAbsent(value, v -> {
            this.indexEntry.add((Binary)v);
            this.mapSize += (long)v.getLength();
            return this.entryIndex.size();
        });
        this.valuesEncoder.encode(this.entryIndex.get(value), out);
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        try {
            this.writeMap(out);
            this.writeEncodedData(out);
        }
        catch (IOException e) {
            logger.error("tsfile-encoding DictionaryEncoder: error occurs when flushing", e);
        }
        this.reset();
    }

    @Override
    public int getOneItemMaxSize() {
        return 12;
    }

    @Override
    public long getMaxByteSize() {
        return 4L + this.mapSize + this.valuesEncoder.getMaxByteSize();
    }

    private void writeMap(ByteArrayOutputStream out) throws IOException {
        ReadWriteForEncodingUtils.writeVarInt(this.indexEntry.size(), out);
        for (Binary value : this.indexEntry) {
            ReadWriteForEncodingUtils.writeVarInt(value.getLength(), out);
            out.write(value.getValues());
        }
    }

    private void writeEncodedData(ByteArrayOutputStream out) throws IOException {
        this.valuesEncoder.flush(out);
    }

    private void reset() {
        this.entryIndex.clear();
        this.indexEntry.clear();
        this.valuesEncoder.reset();
        this.mapSize = 0L;
    }
}

