/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.udf.builtin.UDTFEqualSizeBucketSample;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFEqualSizeBucketM4Sample
extends UDTFEqualSizeBucketSample {
    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.bucketSize *= 4;
        configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(this.bucketSize)).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws UDFException, IOException {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(rowWindow, collector);
                break;
            }
            case INT64: {
                this.transformLong(rowWindow, collector);
                break;
            }
            case FLOAT: {
                this.transformFloat(rowWindow, collector);
                break;
            }
            case DOUBLE: {
                this.transformDouble(rowWindow, collector);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }

    public void transformInt(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() <= 4) {
            for (int i = 0; i < rowWindow.windowSize(); ++i) {
                Row row = rowWindow.getRow(i);
                collector.putInt(row.getTime(), row.getInt(0));
            }
            return;
        }
        int minIndex = 1;
        int maxIndex = 1;
        int maxValue = rowWindow.getRow(1).getInt(0);
        int minValue = rowWindow.getRow(1).getInt(0);
        for (int i = 2; i < rowWindow.windowSize() - 1; ++i) {
            int value = rowWindow.getRow(i).getInt(0);
            if (minValue > value) {
                minValue = value;
                minIndex = i;
            }
            if (maxValue >= value) continue;
            maxValue = value;
            maxIndex = i;
        }
        if (minIndex == maxIndex) {
            maxIndex = rowWindow.windowSize() - 2;
        }
        Row row = rowWindow.getRow(0);
        collector.putInt(row.getTime(), row.getInt(0));
        if (maxIndex < minIndex) {
            row = rowWindow.getRow(maxIndex);
            collector.putInt(row.getTime(), row.getInt(0));
            row = rowWindow.getRow(minIndex);
        } else {
            row = rowWindow.getRow(minIndex);
            collector.putInt(row.getTime(), row.getInt(0));
            row = rowWindow.getRow(maxIndex);
        }
        collector.putInt(row.getTime(), row.getInt(0));
        row = rowWindow.getRow(rowWindow.windowSize() - 1);
        collector.putInt(row.getTime(), row.getInt(0));
    }

    public void transformLong(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() <= 4) {
            for (int i = 0; i < rowWindow.windowSize(); ++i) {
                Row row = rowWindow.getRow(i);
                collector.putLong(row.getTime(), row.getLong(0));
            }
            return;
        }
        int minIndex = 1;
        int maxIndex = 1;
        long maxValue = rowWindow.getRow(1).getLong(0);
        long minValue = rowWindow.getRow(1).getLong(0);
        for (int i = 2; i < rowWindow.windowSize() - 1; ++i) {
            long value = rowWindow.getRow(i).getLong(0);
            if (minValue > value) {
                minValue = value;
                minIndex = i;
            }
            if (maxValue >= value) continue;
            maxValue = value;
            maxIndex = i;
        }
        if (minIndex == maxIndex) {
            maxIndex = rowWindow.windowSize() - 2;
        }
        Row row = rowWindow.getRow(0);
        collector.putLong(row.getTime(), row.getLong(0));
        if (maxIndex < minIndex) {
            row = rowWindow.getRow(maxIndex);
            collector.putLong(row.getTime(), row.getLong(0));
            row = rowWindow.getRow(minIndex);
        } else {
            row = rowWindow.getRow(minIndex);
            collector.putLong(row.getTime(), row.getLong(0));
            row = rowWindow.getRow(maxIndex);
        }
        collector.putLong(row.getTime(), row.getLong(0));
        row = rowWindow.getRow(rowWindow.windowSize() - 1);
        collector.putLong(row.getTime(), row.getLong(0));
    }

    public void transformFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() <= 4) {
            for (int i = 0; i < rowWindow.windowSize(); ++i) {
                Row row = rowWindow.getRow(i);
                collector.putFloat(row.getTime(), row.getFloat(0));
            }
            return;
        }
        int minIndex = 1;
        int maxIndex = 1;
        float maxValue = rowWindow.getRow(1).getFloat(0);
        float minValue = rowWindow.getRow(1).getFloat(0);
        for (int i = 2; i < rowWindow.windowSize() - 1; ++i) {
            float value = rowWindow.getRow(i).getFloat(0);
            if (minValue > value) {
                minValue = value;
                minIndex = i;
            }
            if (!(maxValue < value)) continue;
            maxValue = value;
            maxIndex = i;
        }
        if (minIndex == maxIndex) {
            maxIndex = rowWindow.windowSize() - 2;
        }
        Row row = rowWindow.getRow(0);
        collector.putFloat(row.getTime(), row.getFloat(0));
        if (maxIndex < minIndex) {
            row = rowWindow.getRow(maxIndex);
            collector.putFloat(row.getTime(), row.getFloat(0));
            row = rowWindow.getRow(minIndex);
        } else {
            row = rowWindow.getRow(minIndex);
            collector.putFloat(row.getTime(), row.getFloat(0));
            row = rowWindow.getRow(maxIndex);
        }
        collector.putFloat(row.getTime(), row.getFloat(0));
        row = rowWindow.getRow(rowWindow.windowSize() - 1);
        collector.putFloat(row.getTime(), row.getFloat(0));
    }

    public void transformDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
        if (rowWindow.windowSize() <= 4) {
            for (int i = 0; i < rowWindow.windowSize(); ++i) {
                Row row = rowWindow.getRow(i);
                collector.putDouble(row.getTime(), row.getDouble(0));
            }
            return;
        }
        int minIndex = 1;
        int maxIndex = 1;
        double maxValue = rowWindow.getRow(1).getDouble(0);
        double minValue = rowWindow.getRow(1).getDouble(0);
        for (int i = 2; i < rowWindow.windowSize() - 1; ++i) {
            double value = rowWindow.getRow(i).getDouble(0);
            if (minValue > value) {
                minValue = value;
                minIndex = i;
            }
            if (!(maxValue < value)) continue;
            maxValue = value;
            maxIndex = i;
        }
        if (minIndex == maxIndex) {
            maxIndex = rowWindow.windowSize() - 2;
        }
        Row row = rowWindow.getRow(0);
        collector.putDouble(row.getTime(), row.getDouble(0));
        if (maxIndex < minIndex) {
            row = rowWindow.getRow(maxIndex);
            collector.putDouble(row.getTime(), row.getDouble(0));
            row = rowWindow.getRow(minIndex);
        } else {
            row = rowWindow.getRow(minIndex);
            collector.putDouble(row.getTime(), row.getDouble(0));
            row = rowWindow.getRow(maxIndex);
        }
        collector.putDouble(row.getTime(), row.getDouble(0));
        row = rowWindow.getRow(rowWindow.windowSize() - 1);
        collector.putDouble(row.getTime(), row.getDouble(0));
    }
}

