/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFChangePoints
implements UDTF {
    private boolean isFirst = true;
    private Type dataType;
    private boolean cacheBoolean;
    private int cacheInt;
    private long cacheLong;
    private float cacheFloat;
    private double cacheDouble;
    private String cacheString;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        switch (this.dataType) {
            case BOOLEAN: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheBoolean = row.getBoolean(0);
                    collector.putBoolean(row.getTime(), this.cacheBoolean);
                    break;
                }
                boolean rowData = row.getBoolean(0);
                if (rowData == this.cacheBoolean) break;
                this.cacheBoolean = rowData;
                collector.putBoolean(row.getTime(), this.cacheBoolean);
                break;
            }
            case INT32: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheInt = row.getInt(0);
                    collector.putInt(row.getTime(), this.cacheInt);
                    break;
                }
                int rowData = row.getInt(0);
                if (rowData == this.cacheInt) break;
                this.cacheInt = rowData;
                collector.putInt(row.getTime(), this.cacheInt);
                break;
            }
            case INT64: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheLong = row.getLong(0);
                    collector.putLong(row.getTime(), this.cacheLong);
                    break;
                }
                long rowData = row.getLong(0);
                if (rowData == this.cacheLong) break;
                this.cacheLong = rowData;
                collector.putLong(row.getTime(), this.cacheLong);
                break;
            }
            case FLOAT: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheFloat = row.getFloat(0);
                    collector.putFloat(row.getTime(), this.cacheFloat);
                    break;
                }
                float rowData = row.getFloat(0);
                if (rowData == this.cacheFloat) break;
                this.cacheFloat = rowData;
                collector.putFloat(row.getTime(), this.cacheFloat);
                break;
            }
            case DOUBLE: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheDouble = row.getDouble(0);
                    collector.putDouble(row.getTime(), this.cacheDouble);
                    break;
                }
                double rowData = row.getDouble(0);
                if (rowData == this.cacheDouble) break;
                this.cacheDouble = rowData;
                collector.putDouble(row.getTime(), this.cacheDouble);
                break;
            }
            case TEXT: {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.cacheString = row.getString(0);
                    collector.putString(row.getTime(), this.cacheString);
                    break;
                }
                String rowData = row.getString(0);
                if (rowData.equals(this.cacheString)) break;
                this.cacheString = rowData;
                collector.putString(row.getTime(), this.cacheString);
            }
        }
    }
}

