/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

@Deprecated
public class PipeMessage {
    private final String message;
    private final PipeMessageType type;

    public PipeMessage(PipeMessageType type, String message) {
        this.type = type;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public PipeMessageType getType() {
        return this.type;
    }

    public ByteBuffer serializeToByteBuffer() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        ReadWriteIOUtils.write(this.message, (OutputStream)dataOutputStream);
        ReadWriteIOUtils.write(this.type.getType(), (OutputStream)dataOutputStream);
    }

    public static PipeMessage deserialize(ByteBuffer buffer) {
        String message = ReadWriteIOUtils.readString(buffer);
        PipeMessageType type = PipeMessageType.getPipeStatus(ReadWriteIOUtils.readByte(buffer));
        return new PipeMessage(type, message);
    }

    public String toString() {
        return "PipeMessage{message='" + this.message + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum PipeMessageType {
        NORMAL(1),
        WARN(2),
        ERROR(3);

        private final byte type;

        private PipeMessageType(byte type) {
            this.type = type;
        }

        public byte getType() {
            return this.type;
        }

        public static PipeMessageType getPipeStatus(byte type) {
            switch (type) {
                case 1: {
                    return NORMAL;
                }
                case 2: {
                    return WARN;
                }
                case 3: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException("Invalid input: " + type);
        }
    }
}

