/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupCheck;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartupChecks {
    private static final Logger logger = LoggerFactory.getLogger(StartupChecks.class);
    private final String nodeRole;
    private static final StartupCheck checkJDK = () -> {
        int version = JVMCommonUtils.getJdkVersion();
        if (version < 8) {
            throw new StartupException(String.format("Requires JDK version >= %d, current version is %d.", 8, version));
        }
        logger.info("JDK version is {}.", (Object)version);
    };
    protected final List<StartupCheck> preChecks = new ArrayList<StartupCheck>();

    protected StartupChecks(String nodeRole) {
        this.nodeRole = nodeRole;
    }

    private void checkJMXPort(String nodeRole) {
        boolean jmxLocal = Boolean.parseBoolean(System.getProperty("iotdb.jmx.local"));
        String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
        if (jmxLocal) {
            logger.info("Start JMX locally.");
            return;
        }
        if (jmxPort == null) {
            String filename = nodeRole.equals("datanode") ? "datanode-env" : "confignode-env";
            logger.warn("{} missing from {}.sh(Unix or OS X, if you use Windows, check conf/{}.bat)", "com.sun.management.jmxremote.port", filename, filename);
        } else {
            logger.info("Start JMX remotely: JMX is enabled to receive remote connection on port {}", (Object)jmxPort);
        }
    }

    protected void envCheck() {
        this.preChecks.add(() -> this.checkJMXPort(this.nodeRole));
        this.preChecks.add(checkJDK);
    }

    protected void verify() throws StartupException {
        for (StartupCheck check : this.preChecks) {
            check.execute();
        }
    }

    protected abstract void portCheck() throws StartupException;

    protected abstract void startUpCheck() throws Exception;
}

