/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.AndFilter;
import org.apache.iotdb.commons.schema.filter.impl.DataTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.ViewTypeFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class SchemaFilter {
    public static void serialize(SchemaFilter schemaFilter, ByteBuffer byteBuffer) {
        if (schemaFilter == null) {
            ReadWriteIOUtils.write(SchemaFilterType.NULL.getCode(), byteBuffer);
        } else {
            ReadWriteIOUtils.write(schemaFilter.getSchemaFilterType().getCode(), byteBuffer);
            schemaFilter.serialize(byteBuffer);
        }
    }

    public static void serialize(SchemaFilter schemaFilter, DataOutputStream outputStream) throws IOException {
        if (schemaFilter == null) {
            ReadWriteIOUtils.write(SchemaFilterType.NULL.getCode(), (OutputStream)outputStream);
        } else {
            ReadWriteIOUtils.write(schemaFilter.getSchemaFilterType().getCode(), (OutputStream)outputStream);
            schemaFilter.serialize(outputStream);
        }
    }

    public static SchemaFilter deserialize(ByteBuffer byteBuffer) {
        SchemaFilterType type = SchemaFilterType.getSchemaFilterType(ReadWriteIOUtils.readShort(byteBuffer));
        switch (type) {
            case NULL: {
                return null;
            }
            case TAGS_FILTER: {
                return new TagFilter(byteBuffer);
            }
            case PATH_CONTAINS: {
                return new PathContainsFilter(byteBuffer);
            }
            case DATA_TYPE: {
                return new DataTypeFilter(byteBuffer);
            }
            case VIEW_TYPE: {
                return new ViewTypeFilter(byteBuffer);
            }
            case AND: {
                return new AndFilter(byteBuffer);
            }
        }
        throw new IllegalArgumentException("Unsupported schema filter type: " + (Object)((Object)type));
    }

    public static List<SchemaFilter> extract(SchemaFilter schemaFilter, SchemaFilterType filterType) {
        ArrayList<SchemaFilter> res = new ArrayList<SchemaFilter>();
        SchemaFilter.internalExtract(res, schemaFilter, filterType);
        return res;
    }

    private static void internalExtract(List<SchemaFilter> result, SchemaFilter schemaFilter, SchemaFilterType filterType) {
        if (schemaFilter.getSchemaFilterType().equals((Object)filterType)) {
            result.add(schemaFilter);
        }
        if (schemaFilter.getSchemaFilterType().equals((Object)SchemaFilterType.AND)) {
            AndFilter andFilter = (AndFilter)schemaFilter;
            SchemaFilter.internalExtract(result, andFilter.getLeft(), filterType);
            SchemaFilter.internalExtract(result, andFilter.getRight(), filterType);
        }
    }

    public abstract <C> boolean accept(SchemaFilterVisitor<C> var1, C var2);

    public abstract SchemaFilterType getSchemaFilterType();

    public abstract void serialize(ByteBuffer var1);

    public abstract void serialize(DataOutputStream var1) throws IOException;
}

