/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.meta;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipePluginMeta {
    private final String pluginName;
    private final String className;
    private final boolean isBuiltin;
    private final String jarName;
    private final String jarMD5;

    public PipePluginMeta(String pluginName, String className, boolean isBuiltin, String jarName, String jarMD5) {
        this.pluginName = Objects.requireNonNull(pluginName).toUpperCase();
        this.className = Objects.requireNonNull(className);
        this.isBuiltin = isBuiltin;
        if (isBuiltin) {
            this.jarName = jarName;
            this.jarMD5 = jarMD5;
        } else {
            this.jarName = Objects.requireNonNull(jarName);
            this.jarMD5 = Objects.requireNonNull(jarMD5);
        }
    }

    public PipePluginMeta(String pluginName, String className) {
        this.pluginName = Objects.requireNonNull(pluginName).toUpperCase();
        this.className = Objects.requireNonNull(className);
        this.isBuiltin = true;
        this.jarName = null;
        this.jarMD5 = null;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getJarMD5() {
        return this.jarMD5;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.pluginName, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.className, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isBuiltin, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.jarName, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.jarMD5, (OutputStream)outputStream);
    }

    public static PipePluginMeta deserialize(ByteBuffer byteBuffer) {
        String pluginName = ReadWriteIOUtils.readString(byteBuffer);
        String className = ReadWriteIOUtils.readString(byteBuffer);
        boolean isBuiltin = ReadWriteIOUtils.readBool(byteBuffer);
        String jarName = ReadWriteIOUtils.readString(byteBuffer);
        String jarMD5 = ReadWriteIOUtils.readString(byteBuffer);
        return new PipePluginMeta(pluginName, className, isBuiltin, jarName, jarMD5);
    }

    public static PipePluginMeta deserialize(InputStream inputStream) throws IOException {
        return PipePluginMeta.deserialize(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream)));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipePluginMeta that = (PipePluginMeta)obj;
        return this.pluginName.equals(that.pluginName) && this.className.equals(that.className) && this.isBuiltin == that.isBuiltin && Objects.equals(this.jarName, that.jarName) && Objects.equals(this.jarMD5, that.jarMD5);
    }

    public int hashCode() {
        return this.pluginName.hashCode();
    }

    public String toString() {
        return "PipePluginMeta{pluginName='" + this.pluginName + '\'' + ", className='" + this.className + '\'' + ", isBuiltin=" + this.isBuiltin + ", jarName='" + this.jarName + '\'' + ", jarMD5='" + this.jarMD5 + '\'' + '}';
    }
}

