/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.dfa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.IPatternFA;
import org.apache.iotdb.commons.path.fa.dfa.graph.DFAGraph;
import org.apache.iotdb.commons.path.fa.dfa.graph.NFAGraph;
import org.apache.iotdb.commons.path.fa.dfa.transition.DFAPreciseTransition;
import org.apache.iotdb.commons.path.fa.dfa.transition.DFAWildcardTransition;

public class PatternDFA
implements IPatternFA {
    private final List<IFATransition> preciseMatchTransitionList = new ArrayList<IFATransition>();
    private final List<IFATransition> batchMatchTransitionList = new ArrayList<IFATransition>();
    private final Map<String, IFATransition> transitionMap = new HashMap<String, IFATransition>();
    private final DFAGraph dfaGraph;
    private final Map<String, IFATransition>[] preciseMatchTransitionCached;
    private final List<IFATransition>[] batchMatchTransitionCached;

    public PatternDFA(PartialPath pathPattern, boolean isPrefix) {
        boolean wildcard = false;
        AtomicInteger transitionIndex = new AtomicInteger();
        for (String node : pathPattern.getNodes()) {
            if ("*".equals(node) || "**".equals(node)) {
                wildcard = true;
                continue;
            }
            this.transitionMap.computeIfAbsent(node, i -> {
                DFAPreciseTransition transition = new DFAPreciseTransition(transitionIndex.getAndIncrement(), node);
                this.preciseMatchTransitionList.add(transition);
                return transition;
            });
        }
        if (wildcard || isPrefix) {
            DFAWildcardTransition transition = new DFAWildcardTransition(transitionIndex.getAndIncrement(), new ArrayList<String>(this.transitionMap.keySet()));
            this.transitionMap.put(transition.getAcceptEvent(), transition);
            this.batchMatchTransitionList.add(transition);
        }
        NFAGraph nfaGraph = new NFAGraph(pathPattern, isPrefix, this.transitionMap);
        this.dfaGraph = new DFAGraph(nfaGraph, this.transitionMap.values());
        this.preciseMatchTransitionCached = new HashMap[this.dfaGraph.getStateSize()];
        this.batchMatchTransitionCached = new List[this.dfaGraph.getStateSize()];
    }

    public PatternDFA(PathPatternTree prefixOrFullPatternTree) {
        boolean wildcard = false;
        AtomicInteger transitionIndex = new AtomicInteger();
        for (PartialPath pathPattern : prefixOrFullPatternTree.getAllPathPatterns()) {
            for (String node : pathPattern.getNodes()) {
                if ("*".equals(node) || "**".equals(node)) {
                    wildcard = true;
                    continue;
                }
                this.transitionMap.computeIfAbsent(node, i -> {
                    DFAPreciseTransition transition = new DFAPreciseTransition(transitionIndex.getAndIncrement(), node);
                    this.preciseMatchTransitionList.add(transition);
                    return transition;
                });
            }
        }
        if (wildcard) {
            DFAWildcardTransition transition = new DFAWildcardTransition(transitionIndex.getAndIncrement(), new ArrayList<String>(this.transitionMap.keySet()));
            this.transitionMap.put(transition.getAcceptEvent(), transition);
            this.batchMatchTransitionList.add(transition);
        }
        NFAGraph nfaGraph = new NFAGraph(prefixOrFullPatternTree, this.transitionMap);
        this.dfaGraph = new DFAGraph(nfaGraph, this.transitionMap.values());
        this.preciseMatchTransitionCached = new HashMap[this.dfaGraph.getStateSize()];
        this.batchMatchTransitionCached = new List[this.dfaGraph.getStateSize()];
    }

    public IFAState getNextState(IFAState currentState, String acceptEvent) {
        if (this.transitionMap.containsKey(acceptEvent)) {
            return this.dfaGraph.getNextState(currentState, this.transitionMap.get(acceptEvent));
        }
        Iterator<IFATransition> fuzzyMatchTransitionIterator = this.getFuzzyMatchTransitionIterator(currentState);
        while (fuzzyMatchTransitionIterator.hasNext()) {
            IFATransition transition = fuzzyMatchTransitionIterator.next();
            if (!transition.isMatch(acceptEvent)) continue;
            return this.dfaGraph.getNextState(currentState, transition);
        }
        return null;
    }

    @Override
    public Map<String, IFATransition> getPreciseMatchTransition(IFAState state) {
        if (this.preciseMatchTransitionCached[state.getIndex()] == null) {
            this.preciseMatchTransitionCached[state.getIndex()] = this.dfaGraph.getPreciseMatchTransition(state, this.preciseMatchTransitionList);
        }
        return this.preciseMatchTransitionCached[state.getIndex()];
    }

    @Override
    public Iterator<IFATransition> getPreciseMatchTransitionIterator(IFAState state) {
        if (this.preciseMatchTransitionCached[state.getIndex()] == null) {
            this.preciseMatchTransitionCached[state.getIndex()] = this.dfaGraph.getPreciseMatchTransition(state, this.preciseMatchTransitionList);
        }
        return this.preciseMatchTransitionCached[state.getIndex()].values().iterator();
    }

    @Override
    public Iterator<IFATransition> getFuzzyMatchTransitionIterator(IFAState state) {
        if (this.batchMatchTransitionCached[state.getIndex()] == null) {
            this.batchMatchTransitionCached[state.getIndex()] = this.dfaGraph.getTransition(state, this.batchMatchTransitionList);
        }
        return this.batchMatchTransitionCached[state.getIndex()].iterator();
    }

    @Override
    public int getFuzzyMatchTransitionSize(IFAState state) {
        if (this.batchMatchTransitionCached[state.getIndex()] == null) {
            this.batchMatchTransitionCached[state.getIndex()] = this.dfaGraph.getTransition(state, this.batchMatchTransitionList);
        }
        return this.batchMatchTransitionCached[state.getIndex()].size();
    }

    @Override
    public IFAState getNextState(IFAState currentState, IFATransition transition) {
        return this.dfaGraph.getNextState(currentState, transition);
    }

    @Override
    public IFAState getInitialState() {
        return this.dfaGraph.getInitialState();
    }

    @Override
    public int getStateSize() {
        return this.dfaGraph.getStateSize();
    }

    @Override
    public IFAState getState(int index) {
        return this.dfaGraph.getState(index);
    }

    @Override
    public boolean mayTransitionOverlap() {
        return false;
    }

    public List<IFATransition> getTransition(IFAState state) {
        return this.dfaGraph.getTransition(state, this.transitionMap.values());
    }
}

