/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IoTProgressIndex
extends ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Integer, Long> peerId2SearchIndex = new HashMap<Integer, Long>();

    private IoTProgressIndex() {
    }

    public IoTProgressIndex(Integer peerId, Long searchIndex) {
        this.peerId2SearchIndex.put(peerId, searchIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.IOT_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write(this.peerId2SearchIndex.size(), byteBuffer);
            for (Map.Entry<Integer, Long> entry : this.peerId2SearchIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), byteBuffer);
                ReadWriteIOUtils.write((long)entry.getValue(), byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.IOT_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write(this.peerId2SearchIndex.size(), stream);
            for (Map.Entry<Integer, Long> entry : this.peerId2SearchIndex.entrySet()) {
                ReadWriteIOUtils.write((int)entry.getKey(), stream);
                ReadWriteIOUtils.write((long)entry.getValue(), stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof IoTProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            boolean bl = thatIoTProgressIndex.peerId2SearchIndex.entrySet().stream().noneMatch(entry -> !thisIoTProgressIndex.peerId2SearchIndex.containsKey(entry.getKey()) || thisIoTProgressIndex.peerId2SearchIndex.get(entry.getKey()) <= (Long)entry.getValue());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof IoTProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            boolean bl = thisIoTProgressIndex.peerId2SearchIndex.size() == thatIoTProgressIndex.peerId2SearchIndex.size() && thatIoTProgressIndex.peerId2SearchIndex.entrySet().stream().allMatch(entry -> thisIoTProgressIndex.peerId2SearchIndex.containsKey(entry.getKey()) && thisIoTProgressIndex.peerId2SearchIndex.get(entry.getKey()).equals(entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IoTProgressIndex)) {
            return false;
        }
        return this.equals((IoTProgressIndex)obj);
    }

    public int hashCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof IoTProgressIndex)) {
                ProgressIndex progressIndex2 = ProgressIndex.blendProgressIndex(this, progressIndex);
                return progressIndex2;
            }
            IoTProgressIndex thisIoTProgressIndex = this;
            IoTProgressIndex thatIoTProgressIndex = (IoTProgressIndex)progressIndex;
            thatIoTProgressIndex.peerId2SearchIndex.forEach((thatK, thatV) -> thisIoTProgressIndex.peerId2SearchIndex.compute((Integer)thatK, (thisK, thisV) -> thisV == null ? thatV : Math.max(thisV, thatV)));
            IoTProgressIndex ioTProgressIndex = this;
            return ioTProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.IOT_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        this.lock.readLock().lock();
        try {
            ProgressIndex.TotalOrderSumTuple totalOrderSumTuple = new ProgressIndex.TotalOrderSumTuple(this.peerId2SearchIndex.values().stream().mapToLong(Long::longValue).sum());
            return totalOrderSumTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static IoTProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        IoTProgressIndex ioTProgressIndex = new IoTProgressIndex();
        int size = ReadWriteIOUtils.readInt(byteBuffer);
        for (int i = 0; i < size; ++i) {
            int peerId = ReadWriteIOUtils.readInt(byteBuffer);
            long searchIndex = ReadWriteIOUtils.readLong(byteBuffer);
            ioTProgressIndex.peerId2SearchIndex.put(peerId, searchIndex);
        }
        return ioTProgressIndex;
    }

    public static IoTProgressIndex deserializeFrom(InputStream stream) throws IOException {
        IoTProgressIndex ioTProgressIndex = new IoTProgressIndex();
        int size = ReadWriteIOUtils.readInt(stream);
        for (int i = 0; i < size; ++i) {
            int peerId = ReadWriteIOUtils.readInt(stream);
            long searchIndex = ReadWriteIOUtils.readLong(stream);
            ioTProgressIndex.peerId2SearchIndex.put(peerId, searchIndex);
        }
        return ioTProgressIndex;
    }

    public String toString() {
        return "IoTProgressIndex{peerId2SearchIndex=" + this.peerId2SearchIndex + '}';
    }
}

