/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent.threadpool;

import com.google.common.base.Throwables;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledExecutorUtil {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledExecutorUtil.class);

    public static ScheduledFuture<?> safelyScheduleAtFixedRate(ScheduledExecutorService executor, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ScheduledExecutorUtil.scheduleAtFixedRate(executor, command, initialDelay, period, unit, false);
    }

    public static ScheduledFuture<?> safelyScheduleWithFixedDelay(ScheduledExecutorService executor, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ScheduledExecutorUtil.scheduleWithFixedDelay(executor, command, initialDelay, delay, unit, false);
    }

    public static ScheduledFuture<?> unsafelyScheduleAtFixedRate(ScheduledExecutorService executor, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ScheduledExecutorUtil.scheduleAtFixedRate(executor, command, initialDelay, period, unit, true);
    }

    public static ScheduledFuture<?> unsafelyScheduleWithFixedDelay(ScheduledExecutorService executor, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ScheduledExecutorUtil.scheduleWithFixedDelay(executor, command, initialDelay, delay, unit, true);
    }

    private static ScheduledFuture<?> scheduleAtFixedRate(ScheduledExecutorService executor, Runnable command, long initialDelay, long period, TimeUnit unit, boolean unsafe) {
        return executor.scheduleAtFixedRate(() -> {
            block2: {
                try {
                    command.run();
                }
                catch (Throwable t2) {
                    logger.error("Schedule task failed", t2);
                    if (!unsafe) break block2;
                    throw t2;
                }
            }
        }, initialDelay, period, unit);
    }

    private static ScheduledFuture<?> scheduleWithFixedDelay(ScheduledExecutorService executor, Runnable command, long initialDelay, long delay, TimeUnit unit, boolean unsafe) {
        return executor.scheduleWithFixedDelay(() -> {
            block2: {
                try {
                    command.run();
                }
                catch (Throwable t2) {
                    logger.error("Schedule task failed", t2);
                    if (!unsafe) break block2;
                    throw t2;
                }
            }
        }, initialDelay, delay, unit);
    }

    public static RuntimeException propagate(Throwable throwable) {
        logger.error("Run thread failed", throwable);
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }
}

