/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBDefaultThreadExceptionHandler;

public class IoTThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private Thread.UncaughtExceptionHandler handler = new IoTDBDefaultThreadExceptionHandler();

    public IoTThreadFactory(String poolName) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-IoTDB-" + poolName + "-";
    }

    public IoTThreadFactory(String poolName, Thread.UncaughtExceptionHandler handler) {
        this(poolName);
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t2.isDaemon()) {
            t2.setDaemon(false);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        t2.setUncaughtExceptionHandler(this.handler);
        return t2;
    }
}

