/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.sync;

import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.mpp.rpc.thrift.MPPDataExchangeService;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;

public class SyncDataNodeMPPDataExchangeServiceClient
extends MPPDataExchangeService.Client
implements ThriftClient,
AutoCloseable {
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> clientManager;

    public SyncDataNodeMPPDataExchangeServiceClient(ThriftClientProperty property, TEndPoint endpoint, ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> clientManager) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(RpcTransportFactory.INSTANCE.getTransport(new TSocket(TConfigurationConst.defaultTConfiguration, endpoint.getIp(), endpoint.getPort(), property.getConnectionTimeoutMs()))));
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
        this.getInputProtocol().getTransport().open();
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)((Object)this.getInputProtocol().getTransport())).getTimeOut();
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)((Object)this.getInputProtocol().getTransport())).setTimeout(timeout);
    }

    @Override
    public void close() {
        this.clientManager.returnClient(this.endpoint, this);
    }

    @Override
    public void invalidate() {
        this.getInputProtocol().getTransport().close();
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    public String toString() {
        return String.format("SyncDataNodeMPPDataExchangeServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends ThriftClientFactory<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> {
        public Factory(ClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> clientManager, ThriftClientProperty thriftClientProperty) {
            super(clientManager, thriftClientProperty);
        }

        @Override
        public void destroyObject(TEndPoint endpoint, PooledObject<SyncDataNodeMPPDataExchangeServiceClient> pooledObject) {
            pooledObject.getObject().invalidate();
        }

        @Override
        public PooledObject<SyncDataNodeMPPDataExchangeServiceClient> makeObject(TEndPoint endpoint) throws Exception {
            return new DefaultPooledObject<SyncDataNodeMPPDataExchangeServiceClient>(SyncThriftClientWithErrorHandler.newErrorHandler(SyncDataNodeMPPDataExchangeServiceClient.class, SyncDataNodeMPPDataExchangeServiceClient.class.getConstructor(this.thriftClientProperty.getClass(), endpoint.getClass(), this.clientManager.getClass()), this.thriftClientProperty, endpoint, this.clientManager));
        }

        @Override
        public boolean validateObject(TEndPoint endpoint, PooledObject<SyncDataNodeMPPDataExchangeServiceClient> pooledObject) {
            return pooledObject.getObject().getInputProtocol().getTransport().isOpen();
        }
    }
}

