/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ClientManagerMetrics
implements IMetricSet {
    private static final String CLIENT_MANAGER_NUM_ACTIVE = "client_manager_num_active";
    private static final String CLIENT_MANAGER_NUM_IDLE = "client_manager_num_idle";
    private static final String CLIENT_MANAGER_BORROWED_COUNT = "client_manager_borrowed_count";
    private static final String CLIENT_MANAGER_CREATED_COUNT = "client_manager_created_count";
    private static final String CLIENT_MANAGER_DESTROYED_COUNT = "client_manager_destroyed_count";
    private static final String MEAN_ACTIVE_TIME_MILLIS = "client_manager_mean_active_time";
    private static final String MEAN_BORROW_WAIT_TIME_MILLIS = "client_manager_mean_borrow_wait_time";
    private static final String MEAN_IDLE_TIME_MILLIS = "client_manager_mean_idle_time";
    private final Map<String, GenericKeyedObjectPool<?, ?>> poolMap = new HashMap();
    private AbstractMetricService metricService;

    public static ClientManagerMetrics getInstance() {
        return ClientManagerMetricsHolder.INSTANCE;
    }

    private ClientManagerMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientManager(String poolName, GenericKeyedObjectPool<?, ?> clientPool) {
        ClientManagerMetrics clientManagerMetrics = this;
        synchronized (clientManagerMetrics) {
            if (this.metricService == null) {
                this.poolMap.put(poolName, clientPool);
            } else if (!this.poolMap.containsKey(poolName)) {
                this.poolMap.put(poolName, clientPool);
                this.createMetrics(poolName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ClientManagerMetrics clientManagerMetrics = this;
        synchronized (clientManagerMetrics) {
            for (String poolName : this.poolMap.keySet()) {
                this.createMetrics(poolName);
            }
        }
    }

    private void createMetrics(String poolName) {
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getNumActive(), Tag.NAME.toString(), CLIENT_MANAGER_NUM_ACTIVE, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getNumIdle(), Tag.NAME.toString(), CLIENT_MANAGER_NUM_IDLE, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getBorrowedCount(), Tag.NAME.toString(), CLIENT_MANAGER_BORROWED_COUNT, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getCreatedCount(), Tag.NAME.toString(), CLIENT_MANAGER_CREATED_COUNT, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getDestroyedCount(), Tag.NAME.toString(), CLIENT_MANAGER_DESTROYED_COUNT, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getMeanActiveTimeMillis(), Tag.NAME.toString(), MEAN_ACTIVE_TIME_MILLIS, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getMeanBorrowWaitTimeMillis(), Tag.NAME.toString(), MEAN_BORROW_WAIT_TIME_MILLIS, Tag.TYPE.toString(), poolName);
        this.metricService.createAutoGauge(Metric.CLIENT_MANAGER.toString(), MetricLevel.IMPORTANT, this.poolMap, map -> this.poolMap.get(poolName).getMeanIdleTimeMillis(), Tag.NAME.toString(), MEAN_IDLE_TIME_MILLIS, Tag.TYPE.toString(), poolName);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        for (String poolName : this.poolMap.keySet()) {
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), CLIENT_MANAGER_NUM_ACTIVE, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), CLIENT_MANAGER_NUM_IDLE, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), CLIENT_MANAGER_BORROWED_COUNT, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), CLIENT_MANAGER_CREATED_COUNT, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), CLIENT_MANAGER_DESTROYED_COUNT, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), MEAN_ACTIVE_TIME_MILLIS, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), MEAN_BORROW_WAIT_TIME_MILLIS, Tag.TYPE.toString(), poolName);
            metricService.remove(MetricType.GAUGE, Metric.CLIENT_MANAGER.toString(), Tag.NAME.toString(), MEAN_IDLE_TIME_MILLIS, Tag.TYPE.toString(), poolName);
        }
        this.poolMap.clear();
    }

    private static class ClientManagerMetricsHolder {
        private static final ClientManagerMetrics INSTANCE = new ClientManagerMetrics();

        private ClientManagerMetricsHolder() {
        }
    }
}

