/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.IRoleAccessor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRoleAccessor
implements IRoleAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileRoleAccessor.class);
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private static final String ROLE_SNAPSHOT_FILE_NAME = "system" + File.separator + "roles";
    private final String roleDirPath;
    private final ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private final ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileRoleAccessor(String roleDirPath) {
        this.roleDirPath = roleDirPath;
    }

    @Override
    public Role loadRole(String rolename) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile");
        if (!roleProfile.exists() || !roleProfile.isFile()) {
            File backProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile" + TEMP_SUFFIX);
            if (backProfile.exists() && backProfile.isFile()) {
                roleProfile = backProfile;
            } else {
                return null;
            }
        }
        FileInputStream inputStream = new FileInputStream(roleProfile);
        try {
            Role role;
            Role role2;
            DataInputStream dataInputStream;
            block16: {
                dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                role2 = new Role();
                Pair<String, Boolean> result = IOUtils.readAuthString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
                role2.setName(result.getLeft());
                boolean oldVersion = result.getRight();
                if (!oldVersion) break block16;
                IOUtils.loadRolePrivilege(role2, dataInputStream, STRING_ENCODING, this.strBufferLocal);
                Role role3 = role2;
                dataInputStream.close();
                return role3;
            }
            try {
                role2.setSysPrivilegeSet(dataInputStream.readInt());
                ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                int i = 0;
                while (dataInputStream.available() != 0) {
                    pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal, false));
                    ++i;
                }
                role2.setPrivilegeList(pathPrivilegeList);
                role = role2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return role;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    @Override
    public void saveRole(Role role) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile" + TEMP_SUFFIX);
        File roleDir = new File(this.roleDirPath);
        if (!roleDir.exists() && !roleDir.mkdirs()) {
            LOGGER.error("Failed to create role dir {}", (Object)this.roleDirPath);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(roleProfile);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            byte[] strBuffer = role.getName().getBytes(STRING_ENCODING);
            IOUtils.writeInt(outputStream, -1 * strBuffer.length, this.encodingBufferLocal);
            outputStream.write(strBuffer);
            IOUtils.writeInt(outputStream, role.getAllSysPrivileges(), this.encodingBufferLocal);
            int privilegeNum = role.getPathPrivilegeList().size();
            for (int i = 0; i < privilegeNum; ++i) {
                PathPrivilege pathPrivilege = role.getPathPrivilegeList().get(i);
                IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile");
        IOUtils.replaceFile(roleProfile, oldFile);
    }

    @Override
    public boolean deleteRole(String rolename) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile" + TEMP_SUFFIX);
        if (!roleProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (roleProfile.exists() && !roleProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete role file of %s", rolename));
        }
        return true;
    }

    @Override
    public List<String> listAllRoles() {
        File roleDir = SystemFileFactory.INSTANCE.getFile(this.roleDirPath);
        String[] names = roleDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.roleDirPath);
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, ROLE_SNAPSHOT_FILE_NAME);
        File roleTmpSnapshotDir = systemFileFactory.getFile(roleSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        boolean result = true;
        try {
            result = org.apache.iotdb.commons.utils.FileUtils.copyDir(roleFolder, roleTmpSnapshotDir);
        }
        finally {
            if (roleTmpSnapshotDir.exists() && !roleTmpSnapshotDir.delete()) {
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleTmpSnapshotDir);
            }
        }
        return result &= roleTmpSnapshotDir.renameTo(roleSnapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.roleDirPath);
        File roleTmpFolder = systemFileFactory.getFile(roleFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, ROLE_SNAPSHOT_FILE_NAME);
        if (roleSnapshotDir.exists()) {
            try {
                FileUtils.moveDirectory(roleFolder, roleTmpFolder);
                if (org.apache.iotdb.commons.utils.FileUtils.copyDir(roleSnapshotDir, roleFolder)) return;
                LOGGER.error("Failed to load role folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleFolder);
                FileUtils.moveDirectory(roleTmpFolder, roleFolder);
                return;
            }
            finally {
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleTmpFolder);
            }
        } else {
            LOGGER.info("There are no roles to load.");
        }
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.roleDirPath).mkdirs()) {
            LOGGER.info("role info dir {} is created", (Object)this.roleDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.roleDirPath).exists()) {
            LOGGER.error("role info dir {} can not be created", (Object)this.roleDirPath);
        }
    }

    @Override
    public void cleanRoleFolder() {
        File[] files = SystemFileFactory.INSTANCE.getFile(this.roleDirPath).listFiles();
        if (files != null) {
            for (File file : files) {
                org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRoleOldVer(Role role) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile" + TEMP_SUFFIX);
        File roleDir = new File(this.roleDirPath);
        if (!roleDir.exists() && !roleDir.mkdirs()) {
            LOGGER.error("Failed to create role dir {}", (Object)this.roleDirPath);
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(roleProfile.toPath(), new OpenOption[0]));){
            try {
                IOUtils.writeString(outputStream, role.getName(), STRING_ENCODING, this.encodingBufferLocal);
                int privilegeNum = role.getPathPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = role.getPathPrivilegeList().get(i);
                    IOUtils.writeString(outputStream, pathPrivilege.getPath().getFullPath(), STRING_ENCODING, this.encodingBufferLocal);
                    IOUtils.writeInt(outputStream, pathPrivilege.getPrivileges().size(), this.encodingBufferLocal);
                    for (Integer item : pathPrivilege.getPrivileges()) {
                        IOUtils.writeInt(outputStream, item, this.encodingBufferLocal);
                    }
                }
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile");
        IOUtils.replaceFile(roleProfile, oldFile);
    }
}

