/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.service;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.commons.file.SystemFileFactory;

@ThreadSafe
public class PipePluginClassLoader
extends URLClassLoader {
    private final String libRoot;
    private final AtomicLong activeInstanceCount;
    private volatile boolean deprecated;

    public PipePluginClassLoader(String libRoot) throws IOException {
        super(new URL[0]);
        this.libRoot = libRoot;
        this.activeInstanceCount = new AtomicLong(0L);
        this.deprecated = false;
        this.addUrls();
    }

    private void addUrls() throws IOException {
        try (Stream<Path> pathStream = Files.walk(SystemFileFactory.INSTANCE.getFile(this.libRoot).toPath(), new FileVisitOption[0]);){
            for (Path path2 : pathStream.filter(path -> !path.toFile().isDirectory()).collect(Collectors.toList())) {
                super.addURL(path2.toUri().toURL());
            }
        }
    }

    public synchronized void acquire() {
        this.activeInstanceCount.incrementAndGet();
    }

    public synchronized void release() throws IOException {
        this.activeInstanceCount.decrementAndGet();
        this.closeIfPossible();
    }

    public synchronized void markAsDeprecated() throws IOException {
        this.deprecated = true;
        this.closeIfPossible();
    }

    private void closeIfPossible() throws IOException {
        if (this.deprecated && this.activeInstanceCount.get() == 0L) {
            this.close();
        }
    }
}

