/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadRequests {
    private static final Logger LOG = LoggerFactory.getLogger(ReadRequests.class);
    private final ReadIndexQueue readIndexQueue;
    private final StateMachine stateMachine;

    ReadRequests(RaftProperties properties, StateMachine stateMachine) {
        this.readIndexQueue = new ReadIndexQueue(RaftServerConfigKeys.Read.timeout((RaftProperties)properties));
        this.stateMachine = stateMachine;
    }

    Consumer<Long> getAppliedIndexConsumer() {
        return this.readIndexQueue::complete;
    }

    CompletableFuture<Long> waitToAdvance(long readIndex) {
        if (this.stateMachine.getLastAppliedTermIndex().getIndex() >= readIndex) {
            return CompletableFuture.completedFuture(readIndex);
        }
        return this.readIndexQueue.add(readIndex);
    }

    static class ReadIndexQueue {
        private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
        private final NavigableMap<Long, CompletableFuture<Long>> sorted = new ConcurrentSkipListMap<Long, CompletableFuture<Long>>();
        private final TimeDuration readTimeout;

        ReadIndexQueue(TimeDuration readTimeout) {
            this.readTimeout = readTimeout;
        }

        CompletableFuture<Long> add(long readIndex) {
            MemoizedSupplier supplier = MemoizedSupplier.valueOf(CompletableFuture::new);
            CompletableFuture f = this.sorted.computeIfAbsent(readIndex, i -> (CompletableFuture)supplier.get());
            if (supplier.isInitialized()) {
                this.scheduler.onTimeout(this.readTimeout, () -> this.handleTimeout(readIndex), LOG, () -> "Failed to handle read timeout for index " + readIndex);
            }
            return f;
        }

        private void handleTimeout(long readIndex) {
            Optional.ofNullable(this.sorted.remove(readIndex)).ifPresent(consumer -> consumer.completeExceptionally((Throwable)new ReadException((Throwable)new TimeoutIOException("Read timeout for index " + readIndex))));
        }

        void complete(Long appliedIndex) {
            while (!this.sorted.isEmpty()) {
                Long first = (Long)this.sorted.firstKey();
                if (first == null || first > appliedIndex) {
                    return;
                }
                Optional.ofNullable(this.sorted.remove(first)).ifPresent(f -> f.complete(appliedIndex));
            }
            return;
        }
    }
}

