/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(TsFileResourceUtils.class);
    private static final String VALIDATE_FAILED = "validate failed,";

    public static boolean validateTsFileResourceCorrectness(TsFileResource resource) {
        try {
            DeviceTimeIndex timeIndex = resource.getTimeIndexType() != 1 ? resource.buildDeviceTimeIndex() : (DeviceTimeIndex)resource.getTimeIndex();
            if (timeIndex == null) {
                logger.error("{} {} time index is null", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                return false;
            }
            Set<String> devices = timeIndex.getDevices();
            if (devices.isEmpty()) {
                logger.error("{} {} empty resource", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                return false;
            }
            for (String device : devices) {
                long startTime = timeIndex.getStartTime(device);
                long endTime = timeIndex.getEndTime(device);
                if (startTime == Long.MAX_VALUE) {
                    logger.error("{} {} the start time of {} is {}", new Object[]{resource.getTsFilePath(), VALIDATE_FAILED, device, Long.MAX_VALUE});
                    return false;
                }
                if (endTime == Long.MIN_VALUE) {
                    logger.error("{} {} the end time of {} is {}", new Object[]{resource.getTsFilePath(), VALIDATE_FAILED, device, Long.MIN_VALUE});
                    return false;
                }
                if (startTime <= endTime) continue;
                logger.error("{} {} the start time of {} is greater than end time", new Object[]{resource.getTsFilePath(), VALIDATE_FAILED, device});
                return false;
            }
        }
        catch (IOException e) {
            logger.error("meet error when validate .resource file:{},e", (Object)resource.getTsFilePath());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateTsFileDataCorrectness(TsFileResource resource) {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(resource.getTsFilePath());){
            byte marker;
            if (!reader.isComplete()) {
                logger.error("{} {} illegal tsfile", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                boolean bl = false;
                return bl;
            }
            Map<Long, IChunkMetadata> chunkMetadataMap = TsFileResourceUtils.getChunkMetadata(reader);
            if (chunkMetadataMap.isEmpty()) {
                logger.error("{} {} there is no data in the file", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                boolean bl = false;
                return bl;
            }
            ArrayList<long[]> alignedTimeBatch = new ArrayList<long[]>();
            reader.position((long)"TsFile".getBytes().length + 1L);
            int pageIndex = 0;
            block21: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        long chunkOffset = reader.position();
                        ChunkHeader header = reader.readChunkHeader(marker);
                        IChunkMetadata chunkMetadata = chunkMetadataMap.get(chunkOffset - 1L);
                        if (!chunkMetadata.getMeasurementUid().equals(header.getMeasurementID())) {
                            logger.error("{} chunk start offset is inconsistent with the value in the metadata.", (Object)VALIDATE_FAILED);
                            boolean bl = false;
                            return bl;
                        }
                        int dataSize = header.getDataSize();
                        if (dataSize == 0) continue block21;
                        boolean isHasStatistic = (header.getChunkType() & 0x3F) == 1;
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        pageIndex = 0;
                        if (header.getDataType() == TSDataType.VECTOR) {
                            alignedTimeBatch.clear();
                        }
                        LinkedList<Long> lastNoAlignedPageTimeStamps = new LinkedList<Long>();
                        while (true) {
                            long pageHeaderEndTime;
                            long pageHeaderStartTime;
                            if (dataSize <= 0) continue block21;
                            valueDecoder.reset();
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), isHasStatistic);
                            ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                            if ((header.getChunkType() & 0xFFFFFF80) == -128) {
                                TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
                                long[] pageTimestamps = timePageReader.getNextTimeBatch();
                                pageHeaderStartTime = isHasStatistic ? pageHeader.getStartTime() : chunkMetadata.getStartTime();
                                long l = pageHeaderEndTime = isHasStatistic ? pageHeader.getEndTime() : chunkMetadata.getEndTime();
                                if (!TsFileResourceUtils.validateTimeFrame(alignedTimeBatch, pageTimestamps, pageHeaderStartTime, pageHeaderEndTime, resource)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                alignedTimeBatch.add(pageTimestamps);
                            } else if ((header.getChunkType() & 0x40) == 64) {
                                ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, header.getDataType(), valueDecoder);
                                valuePageReader.nextValueBatch((long[])alignedTimeBatch.get(pageIndex));
                            } else {
                                PageReader pageReader = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                                BatchData batchData = pageReader.getAllSatisfiedPageData();
                                pageHeaderStartTime = isHasStatistic ? pageHeader.getStartTime() : chunkMetadata.getStartTime();
                                pageHeaderEndTime = isHasStatistic ? pageHeader.getEndTime() : chunkMetadata.getEndTime();
                                long pageStartTime = Long.MAX_VALUE;
                                long previousTime = Long.MIN_VALUE;
                                while (batchData.hasCurrent()) {
                                    long currentTime = batchData.currentTime();
                                    if (!lastNoAlignedPageTimeStamps.isEmpty() && currentTime <= (Long)lastNoAlignedPageTimeStamps.getLast()) {
                                        logger.error("{} {} time ranges overlap between pages.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (currentTime <= previousTime) {
                                        logger.error("{} {} the timestamp in the page is repeated or not incremental.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                        boolean bl = false;
                                        return bl;
                                    }
                                    pageStartTime = Math.min(pageStartTime, currentTime);
                                    previousTime = currentTime;
                                    lastNoAlignedPageTimeStamps.add(currentTime);
                                    batchData.next();
                                }
                                if (pageHeaderStartTime != pageStartTime) {
                                    logger.error("{} {} the start time in page is different from that in page header.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                    boolean bl = false;
                                    return bl;
                                }
                                if (pageHeaderEndTime != previousTime) {
                                    logger.error("{} {} the end time in page is different from that in page header.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            ++pageIndex;
                            dataSize -= pageHeader.getSerializedPageSize();
                        }
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        if (chunkGroupHeader.getDeviceID() != null && !chunkGroupHeader.getDeviceID().isEmpty()) continue block21;
                        logger.error("{} {} device id is null or empty.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                        boolean bl = false;
                        return bl;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block21;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Meets error when validating TsFile {}, ", (Object)resource.getTsFilePath(), (Object)e);
            return false;
        }
    }

    private static boolean validateTimeFrame(List<long[]> timeBatch, long[] pageTimestamps, long pageHeaderStartTime, long pageHeaderEndTime, TsFileResource tsFileResource) {
        long[] lastPageTimes;
        if (pageHeaderStartTime != pageTimestamps[0]) {
            logger.error("{} {} the start time in page is different from that in page header.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        if (pageHeaderEndTime != pageTimestamps[pageTimestamps.length - 1]) {
            logger.error("{} {} the end time in page is different from that in page header.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        for (int i = 0; i < pageTimestamps.length - 1; ++i) {
            if (pageTimestamps[i + 1] > pageTimestamps[i]) continue;
            logger.error("{} {} the timestamp in the page is repeated or not incremental.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        if (timeBatch.size() >= 1 && (lastPageTimes = timeBatch.get(timeBatch.size() - 1))[lastPageTimes.length - 1] >= pageTimestamps[0]) {
            logger.error("{} {} time ranges overlap between pages.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        return true;
    }

    public static Map<Long, IChunkMetadata> getChunkMetadata(TsFileSequenceReader reader) throws IOException {
        HashMap<Long, IChunkMetadata> offset2ChunkMetadata = new HashMap<Long, IChunkMetadata>();
        Map device2Metadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                    offset2ChunkMetadata.put(chunkMetadata.getOffsetOfChunkHeader(), chunkMetadata);
                }
            }
        }
        return offset2ChunkMetadata;
    }

    public static boolean validateTsFileResourcesHasNoOverlap(List<TsFileResource> resources) {
        try {
            HashMap<String, Pair> lastEndTimeMap = new HashMap<String, Pair>();
            for (TsFileResource resource : resources) {
                DeviceTimeIndex timeIndex = resource.getTimeIndexType() != 1 ? resource.buildDeviceTimeIndex() : (DeviceTimeIndex)resource.getTimeIndex();
                if (timeIndex == null) {
                    return false;
                }
                Set<String> devices = timeIndex.getDevices();
                for (String device : devices) {
                    long currentStartTime = timeIndex.getStartTime(device);
                    long currentEndTime = timeIndex.getEndTime(device);
                    Pair lastDeviceInfo = lastEndTimeMap.computeIfAbsent(device, x -> new Pair(null, (Object)Long.MIN_VALUE));
                    long lastEndTime = (Long)lastDeviceInfo.right;
                    if (lastEndTime >= currentStartTime) {
                        logger.error("Device {} is overlapped between {} and {}, end time in {} is {}, start time in {} is {}", new Object[]{device, lastDeviceInfo.left, resource, lastDeviceInfo.left, lastEndTime, resource, currentStartTime});
                        return false;
                    }
                    lastDeviceInfo.left = resource;
                    lastDeviceInfo.right = currentEndTime;
                    lastEndTimeMap.put(device, lastDeviceInfo);
                }
            }
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }
}

