/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public abstract class AbstractCrossSpaceEstimator
extends AbstractCompactionEstimator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        CompactionTaskInfo taskInfo;
        if (!this.config.isEnableCompactionMemControl()) {
            return 0L;
        }
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>(seqResources.size() + unseqResources.size());
        resources.addAll(seqResources);
        resources.addAll(unseqResources);
        if (!CompactionEstimateUtils.addReadLock(resources)) {
            return -1L;
        }
        long cost = 0L;
        try {
            taskInfo = this.calculatingCompactionTaskInfo(resources);
            cost += this.calculatingMetadataMemoryCost(taskInfo);
        }
        finally {
            CompactionEstimateUtils.releaseReadLock(resources);
        }
        return cost += this.calculatingDataMemoryCost(taskInfo);
    }
}

