/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.thrift.handler.InternalServiceThriftHandler;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeInternalRPCServiceImpl;
import org.apache.iotdb.db.service.DataNodeInternalRPCServiceMBean;
import org.apache.iotdb.db.service.metrics.DataNodeInternalRPCServiceMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.thrift.server.TServerEventHandler;

public class DataNodeInternalRPCService
extends ThriftService
implements DataNodeInternalRPCServiceMBean {
    private DataNodeInternalRPCServiceImpl impl;

    private DataNodeInternalRPCService() {
    }

    public ServiceType getID() {
        return ServiceType.INTERNAL_SERVICE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.impl = new DataNodeInternalRPCServiceImpl();
        this.initSyncedServiceImpl(null);
        this.processor = new IDataNodeRPCService.Processor((IDataNodeRPCService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.DATANODE_INTERNAL_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new InternalServiceThriftHandler(), config.isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.DATANODE_INTERNAL_RPC_SERVICE.getName());
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeInternalRPCServiceMetrics(this.thriftServiceThread));
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    public static DataNodeInternalRPCService getInstance() {
        return DataNodeInternalRPCServiceHolder.INSTANCE;
    }

    private static class DataNodeInternalRPCServiceHolder {
        private static final DataNodeInternalRPCService INSTANCE = new DataNodeInternalRPCService();

        private DataNodeInternalRPCServiceHolder() {
        }
    }
}

