/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.CachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.ICacheManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.LRUCacheManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.IReleaseFlushStrategy;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.ReleaseFlushStrategyNumBasedImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.ReleaseFlushStrategySizeBasedImpl;
import org.apache.iotdb.db.utils.concurrent.FiniteSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(CacheMemoryManager.class);
    private final List<CachedMTreeStore> storeList = new CopyOnWriteArrayList<CachedMTreeStore>();
    private CachedSchemaEngineStatistics engineStatistics;
    private SchemaEngineCachedMetric engineMetric;
    private static final int CONCURRENT_NUM = 10;
    private ExecutorService flushTaskProcessor;
    private ExecutorService flushTaskMonitor;
    private ExecutorService releaseTaskProcessor;
    private ExecutorService releaseTaskMonitor;
    private FiniteSemaphore flushSemaphore;
    private FiniteSemaphore releaseSemaphore;
    private volatile boolean hasFlushTask;
    private volatile boolean hasReleaseTask;
    private IReleaseFlushStrategy releaseFlushStrategy;
    private static final int MAX_WAITING_TIME_WHEN_RELEASING = 3000;
    private final Object blockObject = new Object();

    public ICacheManager createLRUCacheManager(CachedMTreeStore store, MemManager memManager) {
        LRUCacheManager cacheManager = new LRUCacheManager(memManager);
        this.storeList.add(store);
        return cacheManager;
    }

    public void clearCachedMTreeStore(CachedMTreeStore store) {
        this.storeList.remove(store);
    }

    public void init(ISchemaEngineStatistics engineStatistics) {
        this.flushSemaphore = new FiniteSemaphore(2, 0);
        this.releaseSemaphore = new FiniteSemaphore(2, 0);
        this.engineStatistics = engineStatistics.getAsCachedSchemaEngineStatistics();
        this.releaseFlushStrategy = IoTDBDescriptor.getInstance().getConfig().getCachedMNodeSizeInPBTreeMode() >= 0 ? new ReleaseFlushStrategyNumBasedImpl(this.engineStatistics) : new ReleaseFlushStrategySizeBasedImpl(this.engineStatistics);
        this.flushTaskMonitor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.SCHEMA_FLUSH_MONITOR.getName());
        this.flushTaskProcessor = IoTDBThreadPoolFactory.newFixedThreadPool((int)10, (String)ThreadName.SCHEMA_REGION_FLUSH_PROCESSOR.getName());
        this.releaseTaskMonitor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.SCHEMA_RELEASE_MONITOR.getName());
        this.releaseTaskProcessor = IoTDBThreadPoolFactory.newFixedThreadPool((int)10, (String)ThreadName.SCHEMA_REGION_RELEASE_PROCESSOR.getName());
        this.releaseTaskMonitor.submit(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.releaseSemaphore.acquire();
                    try {
                        if (!this.isExceedReleaseThreshold()) continue;
                        this.hasReleaseTask = true;
                        this.tryExecuteMemoryRelease();
                    }
                    catch (Throwable throwable) {
                        this.hasReleaseTask = false;
                        logger.error("Something wrong happened during MTree release.", throwable);
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                logger.info("ReleaseTaskMonitor thread is interrupted.");
                Thread.currentThread().interrupt();
            }
        });
        this.flushTaskMonitor.submit(() -> {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.flushSemaphore.acquire();
                    try {
                        if (!this.isExceedFlushThreshold()) continue;
                        this.hasFlushTask = true;
                        this.tryFlushVolatileNodes();
                    }
                    catch (Throwable throwable) {
                        this.hasFlushTask = false;
                        logger.error("Something wrong happened during MTree flush.", throwable);
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                logger.info("FlushTaskMonitor thread is interrupted.");
                Thread.currentThread().interrupt();
            }
        });
    }

    public void setEngineMetric(SchemaEngineCachedMetric engineMetric) {
        this.engineMetric = engineMetric;
    }

    public boolean isExceedReleaseThreshold() {
        return this.releaseFlushStrategy.isExceedReleaseThreshold();
    }

    public boolean isExceedFlushThreshold() {
        return this.releaseFlushStrategy.isExceedFlushThreshold();
    }

    public void ensureMemoryStatus() {
        if (this.isExceedReleaseThreshold()) {
            this.registerReleaseTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfReleasing() {
        Object object = this.blockObject;
        synchronized (object) {
            if (this.hasReleaseTask || this.hasFlushTask) {
                try {
                    this.blockObject.wait(3000L);
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupt because the release task and flush task did not finish within {} milliseconds.", (Object)3000);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void registerReleaseTask() {
        this.releaseSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryExecuteMemoryRelease() {
        long startTime = System.currentTimeMillis();
        CompletableFuture.allOf((CompletableFuture[])this.storeList.stream().map(store -> CompletableFuture.runAsync(() -> {
            store.getLock().threadReadLock(true);
            try {
                this.executeMemoryRelease((CachedMTreeStore)store);
            }
            finally {
                store.getLock().threadReadUnlock();
            }
        }, this.releaseTaskProcessor)).toArray(CompletableFuture[]::new)).join();
        if (this.engineMetric != null) {
            this.engineMetric.recordRelease(System.currentTimeMillis() - startTime);
        }
        Object object = this.blockObject;
        synchronized (object) {
            this.hasReleaseTask = false;
            if (this.isExceedFlushThreshold()) {
                this.registerFlushTask();
            } else {
                this.blockObject.notifyAll();
            }
        }
    }

    private void executeMemoryRelease(CachedMTreeStore store) {
        while (this.isExceedReleaseThreshold() && !store.executeMemoryRelease()) {
        }
    }

    private void registerFlushTask() {
        this.flushSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFlushVolatileNodes() {
        long startTime = System.currentTimeMillis();
        CompletableFuture.allOf((CompletableFuture[])this.storeList.stream().map(store -> CompletableFuture.runAsync(() -> {
            store.getLock().writeLock();
            try {
                store.flushVolatileNodes();
                this.executeMemoryRelease((CachedMTreeStore)store);
            }
            finally {
                store.getLock().unlockWrite();
            }
        }, this.flushTaskProcessor)).toArray(CompletableFuture[]::new)).join();
        if (this.engineMetric != null) {
            this.engineMetric.recordFlush(System.currentTimeMillis() - startTime);
        }
        Object object = this.blockObject;
        synchronized (object) {
            this.hasFlushTask = false;
            this.blockObject.notifyAll();
        }
    }

    public void clear() {
        if (this.releaseTaskMonitor != null) {
            this.releaseTaskMonitor.shutdownNow();
            while (!this.releaseTaskMonitor.isTerminated()) {
            }
            this.releaseTaskMonitor = null;
        }
        if (this.flushTaskMonitor != null) {
            this.flushTaskMonitor.shutdownNow();
            while (!this.flushTaskMonitor.isTerminated()) {
            }
            this.releaseTaskMonitor = null;
        }
        if (this.releaseTaskProcessor != null) {
            while (this.hasReleaseTask) {
            }
            this.releaseTaskProcessor.shutdown();
            while (!this.releaseTaskProcessor.isTerminated()) {
            }
            this.releaseTaskProcessor = null;
        }
        if (this.flushTaskProcessor != null) {
            while (this.hasFlushTask) {
            }
            this.flushTaskProcessor.shutdown();
            while (!this.flushTaskProcessor.isTerminated()) {
            }
            this.flushTaskProcessor = null;
        }
        this.storeList.clear();
        this.releaseFlushStrategy = null;
        this.engineStatistics = null;
        this.releaseSemaphore = null;
        this.flushSemaphore = null;
        this.engineMetric = null;
    }

    public int getReleaseThreadNum() {
        return ((WrappedThreadPoolExecutor)this.releaseTaskProcessor).getActiveCount();
    }

    public int getFlushThreadNum() {
        return ((WrappedThreadPoolExecutor)this.flushTaskProcessor).getActiveCount();
    }

    private CacheMemoryManager() {
    }

    public static CacheMemoryManager getInstance() {
        return GlobalCacheManagerHolder.INSTANCE;
    }

    public void forceFlushAndRelease() {
        this.releaseFlushStrategy = new IReleaseFlushStrategy(){

            @Override
            public boolean isExceedReleaseThreshold() {
                return true;
            }

            @Override
            public boolean isExceedFlushThreshold() {
                return true;
            }
        };
        this.registerFlushTask();
    }

    private static class GlobalCacheManagerHolder {
        private static final CacheMemoryManager INSTANCE = new CacheMemoryManager();

        private GlobalCacheManagerHolder() {
        }
    }
}

