/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotPinnedException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.CacheEntry;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.ICacheManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;

public abstract class CacheManager
implements ICacheManager {
    private final MemManager memManager;
    private final NodeBuffer nodeBuffer = new NodeBuffer();

    protected CacheManager(MemManager memManager) {
        this.memManager = memManager;
    }

    @Override
    public void initRootStatus(ICachedMNode root) {
        this.pinMNodeWithMemStatusUpdate(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterMemoryRead(ICachedMNode node) throws MNodeNotCachedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            throw new MNodeNotCachedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            if (this.getCacheEntry(node) == null) {
                throw new MNodeNotCachedException();
            }
            this.pinMNodeWithMemStatusUpdate(node);
        }
        this.updateCacheStatusAfterAccess(cacheEntry);
    }

    @Override
    public void updateCacheStatusAfterDiskRead(ICachedMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        ICachedMNodeContainer.getBelongedContainer(node).addChildToCache(node);
        this.addToNodeCache(cacheEntry, node);
    }

    @Override
    public void updateCacheStatusAfterAppend(ICachedMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        cacheEntry.setVolatile(true);
        ICachedMNodeContainer.getBelongedContainer(node).appendMNode(node);
        this.addToBufferAfterAppend(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBufferAfterAppend(ICachedMNode node) {
        this.removeAncestorsFromCache(node);
        ICachedMNode parent = (ICachedMNode)node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        if (!cacheEntry.isVolatile()) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                if (!cacheEntry.isVolatile()) {
                    this.nodeBuffer.put(cacheEntry, parent);
                }
            }
        }
    }

    private void removeAncestorsFromCache(ICachedMNode node) {
        ICachedMNode parent = (ICachedMNode)node.getParent();
        ICachedMNode current = node;
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        while (!current.isDatabase() && this.isInNodeCache(cacheEntry)) {
            this.removeFromNodeCache(cacheEntry);
            current = parent;
            parent = (ICachedMNode)parent.getParent();
            cacheEntry = this.getCacheEntry(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterUpdate(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (!cacheEntry.isVolatile()) {
            if (!node.isDatabase()) {
                CacheEntry cacheEntry2 = cacheEntry;
                synchronized (cacheEntry2) {
                    cacheEntry.setVolatile(true);
                }
                ICachedMNodeContainer.getBelongedContainer(node).updateMNode(node.getName());
                this.updateCacheStatusAfterUpdate(cacheEntry, node);
                this.removeFromNodeCache(cacheEntry);
            }
            this.addToBufferAfterUpdate(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToBufferAfterUpdate(ICachedMNode node) {
        if (node.isDatabase()) {
            this.nodeBuffer.setUpdatedStorageGroupMNode((IDatabaseMNode<ICachedMNode>)node.getAsDatabaseMNode());
            return;
        }
        this.removeAncestorsFromCache(node);
        ICachedMNode parent = (ICachedMNode)node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(parent);
        if (!cacheEntry.isVolatile()) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                if (!cacheEntry.isVolatile()) {
                    this.nodeBuffer.put(cacheEntry, parent);
                }
            }
        }
        this.nodeBuffer.remove(this.getCacheEntry(node));
    }

    private void addItselfAndAncestorToCache(ICachedMNode node) {
        ICachedMNode tmp = node;
        while (!(tmp.isDatabase() || this.isInNodeCache(this.getCacheEntry(tmp)) || ICachedMNodeContainer.getCachedMNodeContainer(tmp).hasChildrenInBuffer() || this.getCacheEntry(tmp).isVolatile())) {
            this.nodeBuffer.remove(this.getCacheEntry(tmp));
            this.addToNodeCache(this.getCacheEntry(tmp), tmp);
            tmp = (ICachedMNode)tmp.getParent();
        }
    }

    @Override
    public IDatabaseMNode<ICachedMNode> collectUpdatedStorageGroupMNodes() {
        IDatabaseMNode<ICachedMNode> storageGroupMNode = this.nodeBuffer.getUpdatedStorageGroupMNode();
        this.nodeBuffer.setUpdatedStorageGroupMNode(null);
        return storageGroupMNode;
    }

    @Override
    public Iterator<ICachedMNode> collectVolatileSubtrees() {
        return new Iterator<ICachedMNode>(){
            private final Iterator<ICachedMNode> nodeBufferIterator;
            private ICachedMNode nextSubtree;
            {
                this.nodeBufferIterator = CacheManager.this.nodeBuffer.iterator();
                this.nextSubtree = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextSubtree == null) {
                    this.tryGetNext();
                }
                return this.nextSubtree != null;
            }

            @Override
            public ICachedMNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ICachedMNode result = this.nextSubtree;
                this.nextSubtree = null;
                return result;
            }

            private void tryGetNext() {
                while (this.nodeBufferIterator.hasNext()) {
                    ICachedMNode node = this.nodeBufferIterator.next();
                    CacheManager.this.nodeBuffer.remove(CacheManager.this.getCacheEntry(node));
                    if (ICachedMNodeContainer.getCachedMNodeContainer(node).hasChildrenInBuffer()) {
                        this.nextSubtree = node;
                        return;
                    }
                    if (node.isDatabase()) continue;
                    CacheManager.this.addItselfAndAncestorToCache(node);
                }
            }
        };
    }

    @Override
    public Iterator<ICachedMNode> updateCacheStatusAndRetrieveSubtreeAfterPersist(ICachedMNode subtreeRoot) {
        return new VolatileSubtreeIterator(ICachedMNodeContainer.getCachedMNodeContainer(subtreeRoot));
    }

    @Override
    public void updateCacheStatusAfterFlushFailure(ICachedMNode subtreeRoot) {
        this.nodeBuffer.put(this.getCacheEntry(subtreeRoot), subtreeRoot);
        if (subtreeRoot.isDatabase()) {
            return;
        }
        this.removeAncestorsFromCache(subtreeRoot);
    }

    @Override
    public void remove(ICachedMNode node) {
        this.removeRecursively(node);
        this.addItselfAndAncestorToCache((ICachedMNode)node.getParent());
    }

    private void removeOne(CacheEntry cacheEntry, ICachedMNode node) {
        if (this.isInNodeCache(cacheEntry)) {
            this.removeFromNodeCache(cacheEntry);
        } else {
            this.nodeBuffer.remove(cacheEntry);
        }
        node.setCacheEntry(null);
        if (cacheEntry.isPinned()) {
            this.memManager.releasePinnedMemResource(node);
        }
        this.memManager.releaseMemResource(node);
    }

    private void removeRecursively(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return;
        }
        this.removeOne(cacheEntry, node);
        for (ICachedMNode child : node.getChildren().values()) {
            this.removeRecursively(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean evict() {
        ICachedMNode node = null;
        CacheEntry cacheEntry = null;
        ArrayList<ICachedMNode> evictedMNodes = new ArrayList<ICachedMNode>();
        boolean isSuccess = false;
        while (!isSuccess && (node = this.getPotentialNodeTobeEvicted()) != null) {
            CacheEntry cacheEntry2 = cacheEntry = this.getCacheEntry(node);
            synchronized (cacheEntry2) {
                if (!cacheEntry.isPinned() && this.isInNodeCache(cacheEntry)) {
                    String alias;
                    ICachedMNodeContainer.getBelongedContainer(node).evictMNode(node.getName());
                    if (node.isMeasurement() && (alias = node.getAsMeasurementMNode().getAlias()) != null) {
                        ((ICachedMNode)node.getParent()).getAsDeviceMNode().deleteAliasChild(alias);
                    }
                    this.removeFromNodeCache(this.getCacheEntry(node));
                    node.setCacheEntry(null);
                    evictedMNodes.add(node);
                    isSuccess = true;
                }
            }
        }
        if (node != null) {
            this.collectEvictedMNodes(node, evictedMNodes);
        }
        this.memManager.releaseMemResource(evictedMNodes);
        return !evictedMNodes.isEmpty();
    }

    private void collectEvictedMNodes(ICachedMNode node, List<ICachedMNode> evictedMNodes) {
        for (ICachedMNode child : node.getChildren().values()) {
            this.removeFromNodeCache(this.getCacheEntry(child));
            child.setCacheEntry(null);
            evictedMNodes.add(child);
            this.collectEvictedMNodes(child, evictedMNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinMNode(ICachedMNode node) throws MNodeNotPinnedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null || !cacheEntry.isPinned()) {
            throw new MNodeNotPinnedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry = this.getCacheEntry(node);
            if (cacheEntry == null || !cacheEntry.isPinned()) {
                throw new MNodeNotPinnedException();
            }
            this.doPin(node);
        }
    }

    private void pinMNodeWithMemStatusUpdate(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            this.memManager.requestPinnedMemResource(node);
            this.initCacheEntryForNode(node);
        } else if (!cacheEntry.isPinned()) {
            this.memManager.upgradeMemResource(node);
        }
        this.doPin(node);
    }

    private void doPin(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (!cacheEntry.isPinned()) {
            ICachedMNode parent = (ICachedMNode)node.getParent();
            if (!node.isDatabase()) {
                this.getCacheEntry(parent).pin();
            }
        }
        cacheEntry.pin();
    }

    @Override
    public boolean unPinMNode(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return false;
        }
        return this.doUnPin(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUnPin(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        boolean isPinStatusChanged = false;
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry.unPin();
            if (!cacheEntry.isPinned()) {
                isPinStatusChanged = true;
                this.memManager.releasePinnedMemResource(node);
            }
        }
        if (isPinStatusChanged && !node.isDatabase()) {
            this.doUnPin((ICachedMNode)node.getParent());
        }
        return isPinStatusChanged;
    }

    @Override
    public void clear(ICachedMNode root) {
        this.clearMNodeInMemory(root);
        this.clearNodeCache();
        this.nodeBuffer.setUpdatedStorageGroupMNode(null);
        this.nodeBuffer.clear();
    }

    private void clearMNodeInMemory(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return;
        }
        if (cacheEntry.isPinned()) {
            this.memManager.releasePinnedMemResource(node);
        }
        this.memManager.releaseMemResource(node);
        Iterator<ICachedMNode> iterator = ICachedMNodeContainer.getCachedMNodeContainer(node).getChildrenIterator();
        while (iterator.hasNext()) {
            this.clearMNodeInMemory(iterator.next());
        }
    }

    protected CacheEntry getCacheEntry(ICachedMNode node) {
        return node.getCacheEntry();
    }

    @Override
    public long getBufferNodeNum() {
        return this.nodeBuffer.getBufferNodeNum();
    }

    protected void initCacheEntryForNode(ICachedMNode node) {
        node.setCacheEntry(new CacheEntry());
    }

    protected abstract void updateCacheStatusAfterAccess(CacheEntry var1);

    protected abstract void updateCacheStatusAfterUpdate(CacheEntry var1, ICachedMNode var2);

    protected abstract boolean isInNodeCache(CacheEntry var1);

    protected abstract void addToNodeCache(CacheEntry var1, ICachedMNode var2);

    protected abstract void removeFromNodeCache(CacheEntry var1);

    protected abstract ICachedMNode getPotentialNodeTobeEvicted();

    protected abstract void clearNodeCache();

    private static class NodeBuffer {
        private static final int MAP_NUM = 17;
        private IDatabaseMNode<ICachedMNode> updatedStorageGroupMNode;
        private final Map<CacheEntry, ICachedMNode>[] maps = new Map[17];
        private final Map<Integer, NodeBufferIterator> currentIteratorMap = new ConcurrentHashMap<Integer, NodeBufferIterator>();

        NodeBuffer() {
            for (int i = 0; i < 17; ++i) {
                this.maps[i] = new ConcurrentHashMap<CacheEntry, ICachedMNode>();
            }
        }

        public IDatabaseMNode<ICachedMNode> getUpdatedStorageGroupMNode() {
            return this.updatedStorageGroupMNode;
        }

        public void setUpdatedStorageGroupMNode(IDatabaseMNode<ICachedMNode> updatedStorageGroupMNode) {
            this.updatedStorageGroupMNode = updatedStorageGroupMNode;
        }

        void put(CacheEntry cacheEntry, ICachedMNode node) {
            this.maps[this.getLoc(cacheEntry)].put(cacheEntry, node);
            if (!this.currentIteratorMap.isEmpty()) {
                for (NodeBufferIterator nodeBufferIterator : this.currentIteratorMap.values()) {
                    nodeBufferIterator.checkHasNew(this.getLoc(cacheEntry));
                }
            }
        }

        void remove(CacheEntry cacheEntry) {
            this.maps[this.getLoc(cacheEntry)].remove(cacheEntry);
        }

        long getBufferNodeNum() {
            long res = this.updatedStorageGroupMNode == null ? 0L : 1L;
            for (int i = 0; i < 17; ++i) {
                res += (long)this.maps[i].size();
            }
            return res;
        }

        void clear() {
            for (Map<CacheEntry, ICachedMNode> map : this.maps) {
                map.clear();
            }
        }

        private int getLoc(CacheEntry cacheEntry) {
            int hash = cacheEntry.hashCode() % 17;
            return hash < 0 ? hash + 17 : hash;
        }

        Iterator<ICachedMNode> iterator() {
            NodeBufferIterator iterator = new NodeBufferIterator();
            this.currentIteratorMap.put(iterator.hashCode, iterator);
            return iterator;
        }

        private class NodeBufferIterator
        implements Iterator<ICachedMNode> {
            volatile int mapIndex = 0;
            Iterator<ICachedMNode> currentIterator = NodeBuffer.access$600(NodeBuffer.this)[0].values().iterator();
            ICachedMNode nextNode = null;
            volatile boolean hasNew = false;
            private final int hashCode = super.hashCode();

            private NodeBufferIterator() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.nextNode == null) {
                    this.tryGetNext();
                    if (this.nextNode == null && this.hasNew) {
                        NodeBufferIterator nodeBufferIterator = this;
                        synchronized (nodeBufferIterator) {
                            this.hasNew = false;
                            this.mapIndex = 0;
                        }
                        this.currentIterator = NodeBuffer.this.maps[0].values().iterator();
                        this.tryGetNext();
                    }
                }
                if (this.nextNode == null) {
                    NodeBuffer.this.currentIteratorMap.remove(this.hashCode);
                    return false;
                }
                return true;
            }

            @Override
            public ICachedMNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ICachedMNode result = this.nextNode;
                this.nextNode = null;
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void tryGetNext() {
                if (this.mapIndex >= NodeBuffer.this.maps.length) {
                    return;
                }
                while (!this.currentIterator.hasNext()) {
                    this.currentIterator = null;
                    NodeBufferIterator nodeBufferIterator = this;
                    synchronized (nodeBufferIterator) {
                        ++this.mapIndex;
                    }
                    if (this.mapIndex == NodeBuffer.this.maps.length) {
                        return;
                    }
                    this.currentIterator = NodeBuffer.this.maps[this.mapIndex].values().iterator();
                }
                this.nextNode = this.currentIterator.next();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void checkHasNew(int index) {
                if (this.mapIndex >= index) {
                    NodeBufferIterator nodeBufferIterator = this;
                    synchronized (nodeBufferIterator) {
                        if (this.mapIndex >= index) {
                            this.hasNew = true;
                        }
                    }
                }
            }
        }
    }

    private class VolatileSubtreeIterator
    implements Iterator<ICachedMNode> {
        private final ICachedMNodeContainer container;
        private final Iterator<ICachedMNode> bufferedNodeIterator;
        private ICachedMNode nextSubtree = null;

        private VolatileSubtreeIterator(ICachedMNodeContainer container) {
            this.container = container;
            this.bufferedNodeIterator = container.getChildrenBufferIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextSubtree == null) {
                this.tryGetNext();
            }
            return this.nextSubtree != null;
        }

        @Override
        public ICachedMNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ICachedMNode result = this.nextSubtree;
            this.nextSubtree = null;
            return result;
        }

        private void tryGetNext() {
            while (this.bufferedNodeIterator.hasNext()) {
                ICachedMNode node = this.bufferedNodeIterator.next();
                CacheEntry cacheEntry = CacheManager.this.getCacheEntry(node);
                cacheEntry.setVolatile(false);
                this.container.moveMNodeToCache(node.getName());
                if (node.isMeasurement() || !ICachedMNodeContainer.getCachedMNodeContainer(node).hasChildrenInBuffer()) {
                    CacheManager.this.addToNodeCache(cacheEntry, node);
                    ICachedMNode tmp = (ICachedMNode)node.getParent();
                    while (!(tmp.isDatabase() || CacheManager.this.isInNodeCache(CacheManager.this.getCacheEntry(tmp)) || ICachedMNodeContainer.getCachedMNodeContainer(tmp).hasChildrenInBuffer())) {
                        CacheManager.this.addToNodeCache(CacheManager.this.getCacheEntry(tmp), tmp);
                        tmp = (ICachedMNode)tmp.getParent();
                    }
                    continue;
                }
                this.nextSubtree = node;
                return;
            }
        }
    }
}

