/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class InsertRowsOfOneDeviceStatement
extends InsertBaseStatement {
    private List<InsertRowStatement> insertRowStatementList;

    public InsertRowsOfOneDeviceStatement() {
        this.statementType = StatementType.BATCH_INSERT_ONE_DEVICE;
    }

    @Override
    public boolean isEmpty() {
        return this.insertRowStatementList.isEmpty();
    }

    public List<InsertRowStatement> getInsertRowStatementList() {
        return this.insertRowStatementList;
    }

    public void setInsertRowStatementList(List<InsertRowStatement> insertRowStatementList) {
        this.insertRowStatementList = insertRowStatementList;
        if (insertRowStatementList == null || insertRowStatementList.isEmpty()) {
            return;
        }
        this.devicePath = insertRowStatementList.get(0).getDevicePath();
        this.isAligned = insertRowStatementList.get((int)0).isAligned;
        HashSet<String> measurementSet = new HashSet<String>();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (InsertRowStatement insertRowStatement : insertRowStatementList) {
            String[] measurements;
            for (String measurement : measurements = insertRowStatement.getMeasurements()) {
                if (measurementSet.contains(measurement)) continue;
                measurementList.add(measurement);
                measurementSet.add(measurement);
            }
        }
        this.measurements = measurementList.toArray(new String[0]);
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        HashSet<TTimePartitionSlot> timePartitionSlotSet = new HashSet<TTimePartitionSlot>();
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            timePartitionSlotSet.add(TimePartitionUtils.getTimePartitionSlot((long)insertRowStatement.getTime()));
        }
        return new ArrayList<TTimePartitionSlot>(timePartitionSlotSet);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRowsOfOneDevice(this, context);
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        return this.insertRowStatementList.stream().map(InsertRowStatement::getSchemaValidation).collect(Collectors.toList());
    }

    @Override
    public void updateAfterSchemaValidation() throws QueryProcessException {
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            insertRowStatement.updateAfterSchemaValidation();
            if (this.hasFailedMeasurements() || !insertRowStatement.hasFailedMeasurements()) continue;
            this.failedMeasurementIndex2Info = insertRowStatement.failedMeasurementIndex2Info;
        }
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        return false;
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        throw new NotImplementedException();
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        boolean needSplit = false;
        for (InsertRowStatement insertRowStatement : this.insertRowStatementList) {
            if (!insertRowStatement.isNeedSplit()) continue;
            needSplit = true;
        }
        if (needSplit) {
            ArrayList<InsertRowStatement> mergedList = new ArrayList<InsertRowStatement>();
            for (InsertRowStatement child : this.insertRowStatementList) {
                List<InsertRowStatement> childSplitResult = child.getSplitList();
                mergedList.addAll(childSplitResult);
            }
            InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
            insertRowsStatement.setInsertRowStatementList(mergedList);
            return insertRowsStatement;
        }
        return this;
    }
}

