/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;

public class NodePathsSchemaScanNode
extends SchemaQueryScanNode {
    private PartialPath prefixPath;
    private int level = -1;

    public NodePathsSchemaScanNode(PlanNodeId id, PartialPath prefixPath, int level, PathPatternTree scope) {
        super(id);
        this.setScope(scope);
        this.prefixPath = prefixPath;
        this.level = level;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public PlanNode clone() {
        return new NodePathsSchemaScanNode(this.getPlanNodeId(), this.prefixPath, this.level, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.showChildPathsColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.NODE_PATHS_SCAN.serialize(byteBuffer);
        this.prefixPath.serialize(byteBuffer);
        this.scope.serialize(byteBuffer);
        byteBuffer.putInt(this.level);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.NODE_PATHS_SCAN.serialize(stream);
        this.prefixPath.serialize((OutputStream)stream);
        this.scope.serialize(stream);
        stream.writeInt(this.level);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)buffer);
        int level = buffer.getInt();
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new NodePathsSchemaScanNode(planNodeId, path, level, scope);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodePathsSchemaScanNode that = (NodePathsSchemaScanNode)o;
        return this.level == that.level && Objects.equals(this.prefixPath, that.prefixPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefixPath, this.level);
    }

    @Override
    public String toString() {
        return String.format("NodePathsSchemaScanNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

