/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.visitor;

import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeDeviceVisitor;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeMeasurementVisitor;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorWithLimitOffsetWrapper;

public class SchemaTreeVisitorFactory {
    private SchemaTreeVisitorFactory() {
    }

    public static SchemaTreeDeviceVisitor createSchemaTreeDeviceVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        return new SchemaTreeDeviceVisitor(root, pathPattern, isPrefixMatch);
    }

    public static SchemaTreeMeasurementVisitor createSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        return new SchemaTreeMeasurementVisitor(root, pathPattern, isPrefixMatch);
    }

    public static SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> createSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, int slimit, int soffset) {
        return new SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath>(new SchemaTreeMeasurementVisitor(root, pathPattern, isPrefixMatch), slimit, soffset);
    }

    public static SchemaTreeDeviceVisitor createSchemaTreeDeviceVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, PathPatternTree scope) {
        return new SchemaTreeDeviceVisitor(root, pathPattern, isPrefixMatch, scope);
    }

    public static SchemaTreeMeasurementVisitor createSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, PathPatternTree scope) {
        return new SchemaTreeMeasurementVisitor(root, pathPattern, isPrefixMatch, scope);
    }

    public static SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> createSchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, int slimit, int soffset, PathPatternTree scope) {
        return new SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath>(new SchemaTreeMeasurementVisitor(root, pathPattern, isPrefixMatch, scope), slimit, soffset);
    }
}

