/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitor;

public class SchemaTreeDeviceVisitor
extends SchemaTreeVisitor<DeviceSchemaInfo> {
    public SchemaTreeDeviceVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        super(root, pathPattern, isPrefixMatch);
    }

    public SchemaTreeDeviceVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch, PathPatternTree scope) {
        super(root, pathPattern, isPrefixMatch, scope);
    }

    protected boolean mayTargetNodeType(SchemaNode node) {
        return node.isEntity();
    }

    protected boolean acceptInternalMatchedNode(SchemaNode node) {
        return false;
    }

    protected boolean acceptFullMatchedNode(SchemaNode node) {
        return node.isEntity();
    }

    protected DeviceSchemaInfo generateResult(SchemaNode nextMatchedNode) {
        PartialPath path = this.getPartialPathFromRootToNode(nextMatchedNode);
        ArrayList<MeasurementSchemaInfo> measurementSchemaInfoList = new ArrayList<MeasurementSchemaInfo>();
        Iterator<SchemaNode> iterator = this.getChildrenIterator(nextMatchedNode);
        while (iterator.hasNext()) {
            SchemaNode node = iterator.next();
            if (!node.isMeasurement()) continue;
            SchemaMeasurementNode measurementNode = node.getAsMeasurementNode();
            measurementSchemaInfoList.add(new MeasurementSchemaInfo(measurementNode.getName(), measurementNode.getSchema(), measurementNode.getAlias()));
        }
        return new DeviceSchemaInfo(path, nextMatchedNode.getAsEntityNode().isAligned(), measurementSchemaInfoList);
    }
}

