/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftAsyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletRawEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftAsyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftAsyncConnector.class);
    private static final String THRIFT_ERROR_FORMATTER = "Failed to borrow client from client pool or exception occurred when sending to receiver %s:%s.";
    private static final AtomicReference<IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>> ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER = new AtomicReference();
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> asyncPipeDataTransferClientManager;
    private final IoTDBThriftSyncConnector retryConnector = new IoTDBThriftSyncConnector();
    private final PriorityBlockingQueue<Pair<Long, Event>> retryEventQueue = new PriorityBlockingQueue<Pair>(11, Comparator.comparing(o -> (Long)o.left));
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityQueue<Pair<Long, Runnable>> commitQueue = new PriorityQueue<Pair>(Comparator.comparing(o -> (Long)o.left));
    private IoTDBThriftAsyncPipeTransferBatchReqBuilder tabletBatchBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IoTDBThriftAsyncConnector() {
        if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
            Class<IoTDBThriftAsyncConnector> clazz = IoTDBThriftAsyncConnector.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector.class
            if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
                ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.set((IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory()));
            }
            // MONITOREXIT : clazz
        }
        this.asyncPipeDataTransferClientManager = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get();
    }

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        this.retryConnector.validate(validator);
    }

    @Override
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        PipeParameters retryParameters = new PipeParameters(new HashMap(parameters.getAttribute()));
        retryParameters.getAttribute().put("sink.batch.enable", "false");
        retryParameters.getAttribute().put("connector.batch.enable", "false");
        this.retryConnector.customize(retryParameters, configuration);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new IoTDBThriftAsyncPipeTransferBatchReqBuilder(parameters);
        }
    }

    public synchronized void handshake() throws Exception {
        this.retryConnector.handshake();
    }

    public void heartbeat() {
        this.retryConnector.heartbeat();
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (((EnrichedEvent)tabletInsertionEvent).shouldParsePatternOrTime()) {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.transfer(((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).parseEventWithPattern());
            } else {
                this.transfer(((PipeRawTabletInsertionEvent)tabletInsertionEvent).parseEventWithPattern());
            }
            return;
        }
        if (this.isTabletBatchModeEnabled) {
            long requestCommitId = this.commitIdGenerator.incrementAndGet();
            if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent, requestCommitId)) {
                PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler = new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this);
                this.transfer(requestCommitId, pipeTransferTabletBatchEventHandler);
                this.tabletBatchBuilder.onSuccess();
            }
        } else if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            TPipeTransferReq pipeTransferReq = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible() == null ? PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode());
            long requestCommitId = this.commitIdGenerator.incrementAndGet();
            PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferTabletInsertNodeEventHandler(requestCommitId, pipeInsertNodeTabletInsertionEvent, pipeTransferReq, this);
            this.transfer(requestCommitId, pipeTransferInsertNodeReqHandler);
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferTabletRawReq pipeTransferTabletRawReq = PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
            long requestCommitId = this.commitIdGenerator.incrementAndGet();
            PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler = new PipeTransferTabletRawEventHandler(requestCommitId, pipeRawTabletInsertionEvent, (TPipeTransferReq)pipeTransferTabletRawReq, this);
            this.transfer(requestCommitId, pipeTransferTabletReqHandler);
        }
    }

    private void transfer(long requestCommitId, PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            pipeTransferTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
            pipeTransferTabletBatchEventHandler.onError(ex);
        }
    }

    private void transfer(long requestCommitId, PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            pipeTransferInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
            pipeTransferInsertNodeReqHandler.onError(ex);
        }
    }

    private void transfer(long requestCommitId, PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            pipeTransferTabletReqHandler.transfer(client);
        }
        catch (Exception ex) {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
            pipeTransferTabletReqHandler.onError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        if (!pipeTsFileInsertionEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)pipeTsFileInsertionEvent.getTsFile());
            return;
        }
        if (pipeTsFileInsertionEvent.shouldParsePatternOrTime()) {
            try {
                for (TabletInsertionEvent event : pipeTsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.transfer(event);
                }
            }
            finally {
                pipeTsFileInsertionEvent.close();
            }
            return;
        }
        if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
            throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
        }
        long requestCommitId = this.commitIdGenerator.incrementAndGet();
        PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler = new PipeTransferTsFileInsertionEventHandler(requestCommitId, pipeTsFileInsertionEvent, this);
        this.transfer(requestCommitId, pipeTransferTsFileInsertionEventHandler);
    }

    private void transfer(long requestCommitId, PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            pipeTransferTsFileInsertionEventHandler.transfer(client);
        }
        catch (Exception ex) {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
            pipeTransferTsFileInsertionEventHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)event);
        }
    }

    private AsyncPipeDataTransferServiceClient borrowClient(TEndPoint targetNodeUrl) throws Exception {
        AsyncPipeDataTransferServiceClient client;
        while (!this.handshakeIfNecessary(targetNodeUrl, client = (AsyncPipeDataTransferServiceClient)this.asyncPipeDataTransferClientManager.borrowClient((Object)targetNodeUrl))) {
        }
        return client;
    }

    private boolean handshakeIfNecessary(final TEndPoint targetNodeUrl, final AsyncPipeDataTransferServiceClient client) throws Exception {
        if (client.isHandshakeFinished()) {
            return true;
        }
        final AtomicBoolean isHandshakeFinished = new AtomicBoolean(false);
        final AtomicReference exception = new AtomicReference();
        client.pipeTransfer((TPipeTransferReq)PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()), (AsyncMethodCallback)new AsyncMethodCallback<TPipeTransferResp>(){

            public void onComplete(TPipeTransferResp response) {
                if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Handshake error with receiver {}:{}, code: {}, message: {}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage()});
                    exception.set(new PipeConnectionException(String.format("Handshake error with receiver %s:%s, code: %d, message: %s.", targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage())));
                } else {
                    LOGGER.info("Handshake successfully with receiver {}:{}.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                    client.markHandshakeFinished();
                }
                isHandshakeFinished.set(true);
            }

            public void onError(Exception e) {
                LOGGER.warn("Handshake error with receiver {}:{}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e});
                exception.set(e);
                isHandshakeFinished.set(true);
            }
        });
        try {
            while (!isHandshakeFinished.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PipeException("Interrupted while waiting for handshake response.", (Throwable)e);
        }
        if (exception.get() != null) {
            throw new PipeConnectionException("Failed to handshake.", (Throwable)exception.get());
        }
        return false;
    }

    private synchronized void transferQueuedEventsIfNecessary() throws Exception {
        while (!this.retryEventQueue.isEmpty()) {
            Pair<Long, Event> queuedEventPair = this.retryEventQueue.peek();
            long requestCommitId = (Long)queuedEventPair.getLeft();
            Event event = (Event)queuedEventPair.getRight();
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.retryConnector.transfer((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.retryConnector.transfer((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.retryConnector.transfer((PipeTsFileInsertionEvent)event);
            } else {
                LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)event);
            }
            this.commit(requestCommitId, event instanceof EnrichedEvent ? (EnrichedEvent)event : null);
            this.retryEventQueue.poll();
        }
    }

    private void transferBatchedEventsIfNecessary() throws IOException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        long requestCommitId = this.tabletBatchBuilder.getLastCommitId();
        PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler = new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this);
        this.transfer(requestCommitId, pipeTransferTabletBatchEventHandler);
        this.tabletBatchBuilder.onSuccess();
    }

    public synchronized void commit(long requestCommitId, @Nullable EnrichedEvent enrichedEvent) {
        this.commitQueue.offer((Pair<Long, Runnable>)new Pair((Object)requestCommitId, () -> Optional.ofNullable(enrichedEvent).ifPresent(event -> event.decreaseReferenceCount(IoTDBThriftAsyncConnector.class.getName(), true))));
        while (!this.commitQueue.isEmpty()) {
            Pair<Long, Runnable> committer = this.commitQueue.peek();
            if ((Long)committer.left <= this.lastCommitId.get()) {
                this.commitQueue.poll();
                continue;
            }
            if ((Long)committer.left != this.lastCommitId.get() + 1L) break;
            ((Runnable)committer.right).run();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
        }
    }

    public void addFailureEventToRetryQueue(long requestCommitId, Event event) {
        this.retryEventQueue.offer((Pair<Long, Event>)new Pair((Object)requestCommitId, (Object)event));
    }

    public synchronized void close() throws Exception {
        this.retryConnector.close();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
    }
}

