/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcua;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpcUaKeyStoreLoader {
    private static final Pattern IP_ADDR_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String SERVER_ALIAS = "server-ai";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private X509Certificate serverCertificate;
    private KeyPair serverKeyPair;

    OpcUaKeyStoreLoader() {
    }

    OpcUaKeyStoreLoader load(Path baseDir, char[] password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        File serverKeyStore = baseDir.resolve("iotdb-server.pfx").toFile();
        this.logger.info("Loading KeyStore at {}", (Object)serverKeyStore);
        if (!serverKeyStore.exists()) {
            keyStore.load(null, password);
            KeyPair keyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
            String applicationUri = "urn:apache:iotdb:opc-ua-server:" + UUID.randomUUID();
            SelfSignedCertificateBuilder builder = new SelfSignedCertificateBuilder(keyPair).setCommonName("Apache IoTDB OPC UA server").setOrganization("Apache").setOrganizationalUnit("dev").setLocalityName("Beijing").setStateName("China").setCountryCode("CN").setApplicationUri(applicationUri);
            Sets.SetView hostnames = Sets.union((Set)Sets.newHashSet((Object[])new String[]{HostnameUtil.getHostname()}), (Set)HostnameUtil.getHostnames((String)"0.0.0.0", (boolean)false));
            for (String hostname : hostnames) {
                if (IP_ADDR_PATTERN.matcher(hostname).matches()) {
                    builder.addIpAddress(hostname);
                    continue;
                }
                builder.addDnsName(hostname);
            }
            X509Certificate certificate = builder.build();
            keyStore.setKeyEntry(SERVER_ALIAS, keyPair.getPrivate(), password, new X509Certificate[]{certificate});
            keyStore.store(new FileOutputStream(serverKeyStore), password);
        } else {
            keyStore.load(new FileInputStream(serverKeyStore), password);
        }
        Key serverPrivateKey = keyStore.getKey(SERVER_ALIAS, password);
        if (serverPrivateKey instanceof PrivateKey) {
            this.serverCertificate = (X509Certificate)keyStore.getCertificate(SERVER_ALIAS);
            PublicKey serverPublicKey = this.serverCertificate.getPublicKey();
            this.serverKeyPair = new KeyPair(serverPublicKey, (PrivateKey)serverPrivateKey);
        }
        return this;
    }

    X509Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    KeyPair getServerKeyPair() {
        return this.serverKeyPair;
    }
}

