/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.iotdb.commons.pipe.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePluginConstructor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginConstructor.class);
    private final DataNodePipePluginMetaKeeper pipePluginMetaKeeper;
    protected static final Map<String, Supplier<PipePlugin>> PLUGIN_CONSTRUCTORS = new HashMap<String, Supplier<PipePlugin>>();

    PipePluginConstructor(DataNodePipePluginMetaKeeper pipePluginMetaKeeper) {
        this.pipePluginMetaKeeper = pipePluginMetaKeeper;
        this.initConstructors();
    }

    protected abstract void initConstructors();

    abstract PipePlugin reflectPlugin(PipeParameters var1);

    protected final PipePlugin reflectPluginByKey(String pluginKey) {
        return PLUGIN_CONSTRUCTORS.getOrDefault(pluginKey, () -> this.reflect(pluginKey)).get();
    }

    private PipePlugin reflect(String pluginName) {
        PipePluginMeta information = this.pipePluginMetaKeeper.getPipePluginMeta(pluginName);
        if (information == null) {
            String errorMessage = String.format("Failed to reflect PipePlugin instance, because PipePlugin %s has not been registered.", pluginName.toUpperCase());
            LOGGER.warn(errorMessage);
            throw new PipeException(errorMessage);
        }
        try {
            return (PipePlugin)this.pipePluginMetaKeeper.getPluginClass(pluginName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to reflect PipePlugin %s(%s) instance, because %s", pluginName, information.getClassName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }
}

