/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Like<T extends Comparable<T>>
implements Filter,
Serializable {
    private static final long serialVersionUID = 2171102599229260789L;
    protected String value;
    protected FilterType filterType;
    protected Pattern pattern;
    protected boolean not;

    public Like() {
    }

    public Like(String value, FilterType filterType, boolean not) {
        this.value = value;
        this.filterType = filterType;
        this.not = not;
        try {
            String unescapeValue = this.unescapeString(value);
            String specialRegexStr = ".^$*+?{}[]|()";
            StringBuilder patternStrBuild = new StringBuilder();
            patternStrBuild.append("^");
            for (int i = 0; i < unescapeValue.length(); ++i) {
                String ch = String.valueOf(unescapeValue.charAt(i));
                if (specialRegexStr.contains(ch)) {
                    ch = "\\" + unescapeValue.charAt(i);
                }
                if (i == 0 || i > 0 && !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternStrBuild.substring(patternStrBuild.length() - 2, patternStrBuild.length()))) {
                    String replaceStr = ch.replace("%", ".*?").replace("_", ".");
                    patternStrBuild.append(replaceStr);
                    continue;
                }
                patternStrBuild.append(ch);
            }
            patternStrBuild.append("$");
            this.pattern = Pattern.compile(patternStrBuild.toString());
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Regular expression error", value, e.getIndex());
        }
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return true;
    }

    @Override
    public boolean allSatisfy(Statistics statistics) {
        return false;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (this.filterType != FilterType.VALUE_FILTER) {
            throw new UnsupportedOperationException("");
        }
        return this.not != this.pattern.matcher(value.toString()).find();
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return false;
    }

    @Override
    public Filter copy() {
        return new Like<T>(this.value, this.filterType, this.not);
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.write(this.value, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Boolean)this.not, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.value = ReadWriteIOUtils.readString(buffer);
        this.not = ReadWriteIOUtils.readBool(buffer);
    }

    public String toString() {
        return (Object)((Object)this.filterType) + (this.not ? " not like " : " like ") + this.value;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.LIKE;
    }

    @Override
    public Filter reverse() {
        return new Like<T>(this.value, this.filterType, !this.not);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Like)) {
            return false;
        }
        Like like = (Like)o;
        return this.not == like.not && this.value.equals(like.value) && this.filterType == like.filterType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.filterType, this.not});
    }

    private String unescapeString(String value) {
        StringBuilder out = new StringBuilder();
        for (int curIndex = 0; curIndex < value.length(); ++curIndex) {
            String ch = String.valueOf(value.charAt(curIndex));
            if ("\\".equals(ch)) {
                if (curIndex >= value.length() - 1) continue;
                String nextChar = String.valueOf(value.charAt(curIndex + 1));
                if ("%".equals(nextChar) || "_".equals(nextChar) || "\\".equals(nextChar)) {
                    out.append(ch);
                }
                if (!"\\".equals(nextChar)) continue;
                ++curIndex;
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }
}

