/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LongStatistics
extends Statistics<Long> {
    private long minValue;
    private long maxValue;
    private long firstValue;
    private long lastValue;
    private double sumValue;
    static final int LONG_STATISTICS_FIXED_RAM_SIZE = 80;

    @Override
    public TSDataType getType() {
        return TSDataType.INT64;
    }

    @Override
    public int getStatsSize() {
        return 40;
    }

    public void initializeStats(long min, long max, long firstValue, long last, double sum) {
        this.minValue = min;
        this.maxValue = max;
        this.firstValue = firstValue;
        this.lastValue = last;
        this.sumValue += sum;
    }

    @Override
    public Long getMinValue() {
        return this.minValue;
    }

    @Override
    public Long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Long getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Long getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        return this.sumValue;
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.INT64, "long sum"));
    }

    @Override
    void updateStats(long value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value);
        }
    }

    @Override
    void updateStats(long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public void updateStats(long minValue, long maxValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
    }

    private void updateStats(long minValue, long maxValue, long lastValue, double sumValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        this.lastValue = lastValue;
    }

    private void updateStats(long minValue, long maxValue, long firstValue, long lastValue, double sumValue, long startTime, long endTime) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    public long calculateRamSize() {
        return 80L;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<Long> stats) {
        LongStatistics longStats = (LongStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(longStats.getMinValue(), longStats.getMaxValue(), longStats.getFirstValue(), longStats.getLastValue(), longStats.sumValue);
            this.isEmpty = false;
        } else {
            this.updateStats(longStats.getMinValue(), longStats.getMaxValue(), longStats.getFirstValue(), longStats.getLastValue(), longStats.sumValue, stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.minValue = ReadWriteIOUtils.readLong(inputStream);
        this.maxValue = ReadWriteIOUtils.readLong(inputStream);
        this.firstValue = ReadWriteIOUtils.readLong(inputStream);
        this.lastValue = ReadWriteIOUtils.readLong(inputStream);
        this.sumValue = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.minValue = ReadWriteIOUtils.readLong(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readLong(byteBuffer);
        this.firstValue = ReadWriteIOUtils.readLong(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readLong(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readDouble(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongStatistics that = (LongStatistics)o;
        return this.minValue == that.minValue && this.maxValue == that.maxValue && this.firstValue == that.firstValue && this.lastValue == that.lastValue && Double.compare(that.sumValue, this.sumValue) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minValue, this.maxValue, this.firstValue, this.lastValue, this.sumValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [minValue:" + this.minValue + ",maxValue:" + this.maxValue + ",firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + ",sumValue:" + this.sumValue + "]";
    }
}

