/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.apache.iotdb.tsfile.encoding.bitpacking.LongPacker;
import org.apache.iotdb.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.SprintzEncoder;
import org.apache.iotdb.tsfile.encoding.fire.LongFire;
import org.apache.iotdb.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class LongSprintzEncoder
extends SprintzEncoder {
    LongPacker packer;
    LongFire firePred;
    protected Vector<Long> values = new Vector();

    public LongSprintzEncoder() {
        this.firePred = new LongFire(3);
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    public int getOneItemMaxSize() {
        return 1 + (1 + this.Block_size) * 8;
    }

    @Override
    public long getMaxByteSize() {
        return 1L + (1L + (long)this.values.size()) * 8L;
    }

    protected Long predict(Long value, Long preVlaue) throws TsFileEncodingException {
        Long pred;
        if (this.predictMethod.equals("delta")) {
            pred = this.delta(value, preVlaue);
        } else if (this.predictMethod.equals("fire")) {
            pred = this.fire(value, preVlaue);
        } else {
            throw new TsFileEncodingException("Config: Predict Method {} of SprintzEncoder is not supported.");
        }
        pred = pred <= 0L ? Long.valueOf(-2L * pred) : Long.valueOf(2L * pred - 1L);
        return pred;
    }

    @Override
    protected void bitPack() throws IOException {
        long preValue = this.values.get(0);
        this.values.remove(0);
        this.bitWidth = ReadWriteForEncodingUtils.getLongMaxBitWidth(this.values);
        this.packer = new LongPacker(this.bitWidth);
        byte[] bytes = new byte[this.bitWidth];
        long[] tmpBuffer = new long[this.Block_size];
        for (int i = 0; i < this.Block_size; ++i) {
            tmpBuffer[i] = this.values.get(i);
        }
        this.packer.pack8Values(tmpBuffer, 0, bytes);
        ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(this.bitWidth, this.byteCache, 1);
        this.byteCache.write(ByteBuffer.allocate(8).putLong(preValue).array());
        this.byteCache.write(bytes, 0, bytes.length);
    }

    protected Long delta(Long value, Long preValue) {
        return value - preValue;
    }

    protected Long fire(Long value, Long preValue) {
        long pred = this.firePred.predict(preValue);
        long err = value - pred;
        this.firePred.train(preValue, value, err);
        return err;
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        if (this.byteCache.size() > 0) {
            this.byteCache.writeTo(out);
        }
        if (!this.values.isEmpty()) {
            int size = this.values.size();
            ReadWriteForEncodingUtils.writeIntLittleEndianPaddedOnBitWidth(size |= 0x80, out, 1);
            LongRleEncoder encoder = new LongRleEncoder();
            for (long val : this.values) {
                encoder.encode(val, out);
            }
            encoder.flush(out);
        }
        this.reset();
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        if (!this.isFirstCached) {
            this.values.add(value);
            this.isFirstCached = true;
            return;
        }
        this.values.add(value);
        if (this.values.size() == this.Block_size + 1) {
            try {
                long pre = this.values.get(0);
                this.firePred.reset();
                for (int i = 1; i <= this.Block_size; ++i) {
                    long tmp = this.values.get(i);
                    this.values.set(i, this.predict(this.values.get(i), pre));
                    pre = tmp;
                }
                this.bitPack();
                this.isFirstCached = false;
                this.values.clear();
                ++this.groupNum;
                if (this.groupNum == this.groupMax) {
                    this.flush(out);
                }
            }
            catch (IOException e) {
                logger.error("Error occured when encoding INT64 Type value with with Sprintz", (Throwable)e);
            }
        }
    }
}

