/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.Token;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class IoTDBSyntaxHighlighter
implements Highlighter {
    private static final AttributedStyle KEYWORD_STYLE = AttributedStyle.DEFAULT.foreground(2);

    public AttributedString highlight(LineReader reader, String buffer) {
        Token token;
        int type;
        CodePointCharStream stream = CharStreams.fromString((String)buffer);
        SqlLexer tokenSource = new SqlLexer((CharStream)stream);
        tokenSource.removeErrorListeners();
        AttributedStringBuilder builder = new AttributedStringBuilder();
        while ((type = (token = tokenSource.nextToken()).getType()) != -1) {
            String text = token.getText();
            if (this.isKeyword(text)) {
                builder.styled(KEYWORD_STYLE, (CharSequence)text);
                continue;
            }
            builder.append((CharSequence)text);
        }
        return builder.toAttributedString();
    }

    public void setErrorPattern(Pattern errorPattern) {
        IoTPrinter.print("");
    }

    public void setErrorIndex(int errorIndex) {
        IoTPrinter.print("");
    }

    private boolean isKeyword(String token) {
        return JlineUtils.SQL_KEYWORDS.contains(token.toUpperCase());
    }
}

