/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.runtime;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMetaSyncer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeMetaSyncer.class);
    private static final ScheduledExecutorService SYNC_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_META_SYNCER.getName());
    private static final long INITIAL_SYNC_DELAY_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerInitialSyncDelayMinutes();
    private static final long SYNC_INTERVAL_MINUTES = PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes();
    private final ConfigManager configManager;
    private Future<?> metaSyncFuture;
    private final AtomicInteger pipeAutoRestartRoundCounter = new AtomicInteger(0);
    private final boolean pipeAutoRestartEnabled = PipeConfig.getInstance().getPipeAutoRestartEnabled();

    PipeMetaSyncer(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public synchronized void start() {
        while (this.configManager.getConsensusManager() == null) {
            try {
                LOGGER.info("Consensus layer is not ready, sleep 1s...");
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during waiting for consensus layer ready.");
            }
        }
        if (this.metaSyncFuture == null) {
            this.metaSyncFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)SYNC_EXECUTOR, this::sync, (long)INITIAL_SYNC_DELAY_MINUTES, (long)SYNC_INTERVAL_MINUTES, (TimeUnit)TimeUnit.MINUTES);
            LOGGER.info("PipeMetaSyncer is started successfully.");
        }
    }

    private synchronized void sync() {
        if (this.configManager.getPipeManager().getPipeTaskCoordinator().isLocked()) {
            LOGGER.warn("PipeTaskCoordinatorLock is held by another thread, skip this round of sync to avoid procedure and rpc accumulation as much as possible");
            return;
        }
        ProcedureManager procedureManager = this.configManager.getProcedureManager();
        boolean somePipesNeedRestarting = false;
        if (this.pipeAutoRestartEnabled && (long)this.pipeAutoRestartRoundCounter.incrementAndGet() == PipeConfig.getInstance().getPipeMetaSyncerAutoRestartPipeCheckIntervalRound()) {
            somePipesNeedRestarting = this.autoRestartWithLock();
            this.pipeAutoRestartRoundCounter.set(0);
        }
        TSStatus status = procedureManager.pipeMetaSync();
        if (somePipesNeedRestarting && status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.handleSuccessfulRestartWithLock();
            procedureManager.pipeHandleMetaChange(true, false);
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            procedureManager.pipeHandleMetaChange(true, true);
        }
    }

    public synchronized void stop() {
        if (this.metaSyncFuture != null) {
            this.metaSyncFuture.cancel(false);
            this.metaSyncFuture = null;
            LOGGER.info("PipeMetaSyncer is stopped successfully.");
        }
    }

    private boolean autoRestartWithLock() {
        AtomicReference<PipeTaskInfo> pipeTaskInfo = this.configManager.getPipeManager().getPipeTaskCoordinator().tryLock();
        if (pipeTaskInfo == null) {
            LOGGER.warn("Failed to acquire pipe lock for auto restart pipe task.");
            return false;
        }
        try {
            boolean bl = pipeTaskInfo.get().autoRestart();
            return bl;
        }
        finally {
            this.configManager.getPipeManager().getPipeTaskCoordinator().unlock();
        }
    }

    private void handleSuccessfulRestartWithLock() {
        AtomicReference<PipeTaskInfo> pipeTaskInfo = this.configManager.getPipeManager().getPipeTaskCoordinator().tryLock();
        if (pipeTaskInfo == null) {
            LOGGER.warn("Failed to acquire pipe lock for handling successful restart.");
            return;
        }
        try {
            pipeTaskInfo.get().handleSuccessfulRestart();
        }
        finally {
            this.configManager.getPipeManager().getPipeTaskCoordinator().unlock();
        }
    }
}

