/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.runtime;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatParser.class);
    private final ConfigManager configManager;
    private long heartbeatCounter;
    private int registeredDataNodeNumber;
    private final AtomicBoolean needWriteConsensusOnConfigNodes;
    private final AtomicBoolean needPushPipeMetaToDataNodes;

    PipeHeartbeatParser(ConfigManager configManager) {
        this.configManager = configManager;
        this.heartbeatCounter = 0L;
        this.registeredDataNodeNumber = 1;
        this.needWriteConsensusOnConfigNodes = new AtomicBoolean(false);
        this.needPushPipeMetaToDataNodes = new AtomicBoolean(false);
    }

    public synchronized void parseHeartbeat(int dataNodeId, @NotNull List<ByteBuffer> pipeMetaByteBufferListFromDataNode) {
        long heartbeatCount = ++this.heartbeatCounter;
        AtomicBoolean canSubmitHandleMetaChangeProcedure = new AtomicBoolean(false);
        if (heartbeatCount % (long)this.registeredDataNodeNumber == 0L) {
            canSubmitHandleMetaChangeProcedure.set(true);
            this.registeredDataNodeNumber = this.configManager.getNodeManager().getRegisteredDataNodeCount();
            if (this.registeredDataNodeNumber <= 0) {
                LOGGER.warn("registeredDataNodeNumber is {} when parseHeartbeat from data node (id={}).", (Object)this.registeredDataNodeNumber, (Object)dataNodeId);
                this.registeredDataNodeNumber = 1;
            }
        }
        if (pipeMetaByteBufferListFromDataNode.isEmpty() && (!canSubmitHandleMetaChangeProcedure.get() || !this.needWriteConsensusOnConfigNodes.get() && !this.needPushPipeMetaToDataNodes.get())) {
            return;
        }
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().getProcedureSubmitter().submit(() -> {
            AtomicReference<PipeTaskInfo> pipeTaskInfo = this.configManager.getPipeManager().getPipeTaskCoordinator().tryLock();
            if (pipeTaskInfo == null) {
                LOGGER.warn("Failed to acquire lock when parseHeartbeat from data node (id={}).", (Object)dataNodeId);
                return;
            }
            try {
                if (!pipeMetaByteBufferListFromDataNode.isEmpty()) {
                    this.parseHeartbeatAndSaveMetaChangeLocally(pipeTaskInfo, dataNodeId, pipeMetaByteBufferListFromDataNode);
                }
                if (canSubmitHandleMetaChangeProcedure.get() && (this.needWriteConsensusOnConfigNodes.get() || this.needPushPipeMetaToDataNodes.get())) {
                    this.configManager.getProcedureManager().pipeHandleMetaChange(this.needWriteConsensusOnConfigNodes.get(), this.needPushPipeMetaToDataNodes.get());
                    this.needWriteConsensusOnConfigNodes.set(false);
                    this.needPushPipeMetaToDataNodes.set(false);
                }
            }
            finally {
                this.configManager.getPipeManager().getPipeTaskCoordinator().unlock();
            }
        });
    }

    private void parseHeartbeatAndSaveMetaChangeLocally(AtomicReference<PipeTaskInfo> pipeTaskInfo, int dataNodeId, @NotNull List<ByteBuffer> pipeMetaByteBufferListFromDataNode) {
        HashMap<PipeStaticMeta, PipeMeta> pipeMetaMapFromDataNode = new HashMap<PipeStaticMeta, PipeMeta>();
        for (ByteBuffer byteBuffer : pipeMetaByteBufferListFromDataNode) {
            PipeMeta pipeMeta2 = PipeMeta.deserialize((ByteBuffer)byteBuffer);
            pipeMetaMapFromDataNode.put(pipeMeta2.getStaticMeta(), pipeMeta2);
        }
        for (PipeMeta pipeMetaOnConfigNode : pipeTaskInfo.get().getPipeMetaList()) {
            PipeMeta pipeMetaFromDataNode = (PipeMeta)pipeMetaMapFromDataNode.get(pipeMetaOnConfigNode.getStaticMeta());
            if (pipeMetaFromDataNode == null) {
                LOGGER.info("PipeRuntimeCoordinator meets error in updating pipeMetaKeeper, pipeMetaFromDataNode is null, pipeMetaOnConfigNode: {}", (Object)pipeMetaOnConfigNode);
                continue;
            }
            Map pipeTaskMetaMapOnConfigNode = pipeMetaOnConfigNode.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            Map pipeTaskMetaMapFromDataNode = pipeMetaFromDataNode.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (Map.Entry runtimeMetaOnConfigNode : pipeTaskMetaMapOnConfigNode.entrySet()) {
                if (((PipeTaskMeta)runtimeMetaOnConfigNode.getValue()).getLeaderDataNodeId() != dataNodeId) continue;
                PipeTaskMeta runtimeMetaFromDataNode = (PipeTaskMeta)pipeTaskMetaMapFromDataNode.get(runtimeMetaOnConfigNode.getKey());
                if (runtimeMetaFromDataNode == null) {
                    LOGGER.warn("PipeRuntimeCoordinator meets error in updating pipeMetaKeeper, runtimeMetaFromDataNode is null, runtimeMetaOnConfigNode: {}", runtimeMetaOnConfigNode);
                    continue;
                }
                if (!((PipeTaskMeta)runtimeMetaOnConfigNode.getValue()).getProgressIndex().isAfter(runtimeMetaFromDataNode.getProgressIndex()) && !((PipeTaskMeta)runtimeMetaOnConfigNode.getValue()).getProgressIndex().equals(runtimeMetaFromDataNode.getProgressIndex())) {
                    LOGGER.info("Updating progress index for (pipe name: {}, consensus group id: {}) ... Progress index on config node: {}, progress index from data node: {}", new Object[]{pipeMetaOnConfigNode.getStaticMeta().getPipeName(), runtimeMetaOnConfigNode.getKey(), ((PipeTaskMeta)runtimeMetaOnConfigNode.getValue()).getProgressIndex(), runtimeMetaFromDataNode.getProgressIndex()});
                    LOGGER.info("Progress index for (pipe name: {}, consensus group id: {}) is updated to {}", new Object[]{pipeMetaOnConfigNode.getStaticMeta().getPipeName(), runtimeMetaOnConfigNode.getKey(), ((PipeTaskMeta)runtimeMetaOnConfigNode.getValue()).updateProgressIndex(runtimeMetaFromDataNode.getProgressIndex())});
                    this.needWriteConsensusOnConfigNodes.set(true);
                }
                PipeTaskMeta pipeTaskMetaOnConfigNode = (PipeTaskMeta)runtimeMetaOnConfigNode.getValue();
                pipeTaskMetaOnConfigNode.clearExceptionMessages();
                for (PipeRuntimeException exception : runtimeMetaFromDataNode.getExceptionMessages()) {
                    pipeTaskMetaOnConfigNode.trackExceptionMessage(exception);
                    if (!(exception instanceof PipeRuntimeCriticalException)) continue;
                    String pipeName = pipeMetaOnConfigNode.getStaticMeta().getPipeName();
                    if (!((PipeStatus)pipeMetaOnConfigNode.getRuntimeMeta().getStatus().get()).equals((Object)PipeStatus.STOPPED)) {
                        PipeRuntimeMeta runtimeMeta2 = pipeMetaOnConfigNode.getRuntimeMeta();
                        runtimeMeta2.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta2.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(true);
                        LOGGER.warn("Detect PipeRuntimeCriticalException {} from DataNode, stop pipe {}.", (Object)exception, (Object)pipeName);
                    }
                    if (!(exception instanceof PipeRuntimeConnectorCriticalException)) continue;
                    ((PipeTableResp)pipeTaskInfo.get().showPipes()).filter(true, pipeName).getAllPipeMeta().stream().filter(pipeMeta -> !pipeMeta.getStaticMeta().getPipeName().equals(pipeName)).map(PipeMeta::getRuntimeMeta).filter(runtimeMeta -> !((PipeStatus)runtimeMeta.getStatus().get()).equals((Object)PipeStatus.STOPPED)).forEach(runtimeMeta -> {
                        Map exceptionMap = runtimeMeta.getDataNodeId2PipeRuntimeExceptionMap();
                        if (!exceptionMap.containsKey(dataNodeId) || ((PipeRuntimeException)exceptionMap.get(dataNodeId)).getTimeStamp() < exception.getTimeStamp()) {
                            exceptionMap.put(dataNodeId, exception);
                        }
                        runtimeMeta.getStatus().set(PipeStatus.STOPPED);
                        runtimeMeta.setIsStoppedByRuntimeException(true);
                        this.needWriteConsensusOnConfigNodes.set(true);
                        this.needPushPipeMetaToDataNodes.set(true);
                        LOGGER.warn(String.format("Detect PipeRuntimeConnectorCriticalException %s from DataNode, stop pipe %s.", exception, pipeName));
                    });
                }
            }
        }
    }
}

