/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class GetNodePathsPartitionPlan
extends ConfigPhysicalPlan {
    private PartialPath partialPath;
    private PathPatternTree scope;
    private int level = -1;

    public GetNodePathsPartitionPlan() {
        super(ConfigPhysicalPlanType.GetNodePathsPartition);
    }

    public PathPatternTree getScope() {
        return this.scope;
    }

    public void setScope(PathPatternTree scope) {
        this.scope = scope;
    }

    public PartialPath getPartialPath() {
        return this.partialPath;
    }

    public void setPartialPath(PartialPath partialPath) {
        this.partialPath = partialPath;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        this.partialPath.serialize((OutputStream)stream);
        this.scope.serialize(stream);
        stream.writeInt(this.level);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.partialPath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
        this.scope = PathPatternTree.deserialize((ByteBuffer)buffer);
        this.level = buffer.getInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetNodePathsPartitionPlan that = (GetNodePathsPartitionPlan)o;
        return this.level == that.level && Objects.equals(this.partialPath, that.partialPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partialPath, this.level);
    }
}

