/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeExceptionType;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMetaVersion;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTaskMeta {
    private final AtomicReference<ProgressIndex> progressIndex = new AtomicReference();
    private final AtomicInteger leaderDataNodeId = new AtomicInteger(0);
    private final Map<PipeRuntimeException, PipeRuntimeException> exceptionMessages = new ConcurrentHashMap<PipeRuntimeException, PipeRuntimeException>();

    public PipeTaskMeta(ProgressIndex progressIndex, int leaderDataNodeId) {
        this.progressIndex.set(progressIndex);
        this.leaderDataNodeId.set(leaderDataNodeId);
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex.get();
    }

    public ProgressIndex updateProgressIndex(ProgressIndex updateIndex) {
        return this.progressIndex.updateAndGet(index -> index.updateToMinimumIsAfterProgressIndex(updateIndex));
    }

    public int getLeaderDataNodeId() {
        return this.leaderDataNodeId.get();
    }

    public void setLeaderDataNodeId(int leaderDataNodeId) {
        this.leaderDataNodeId.set(leaderDataNodeId);
    }

    public synchronized Iterable<PipeRuntimeException> getExceptionMessages() {
        return new ArrayList<PipeRuntimeException>(this.exceptionMessages.values());
    }

    public synchronized void trackExceptionMessage(PipeRuntimeException exceptionMessage) {
        this.exceptionMessages.put(exceptionMessage, exceptionMessage);
    }

    public synchronized boolean containsExceptionMessage(PipeRuntimeException exceptionMessage) {
        return this.exceptionMessages.containsKey((Object)exceptionMessage);
    }

    public synchronized void clearExceptionMessages() {
        this.exceptionMessages.clear();
    }

    public synchronized void serialize(DataOutputStream outputStream) throws IOException {
        this.progressIndex.get().serialize(outputStream);
        ReadWriteIOUtils.write((int)this.leaderDataNodeId.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.exceptionMessages.size(), (OutputStream)outputStream);
        for (PipeRuntimeException pipeRuntimeException : this.exceptionMessages.values()) {
            pipeRuntimeException.serialize(outputStream);
        }
    }

    public synchronized void serialize(FileOutputStream outputStream) throws IOException {
        this.progressIndex.get().serialize(outputStream);
        ReadWriteIOUtils.write((int)this.leaderDataNodeId.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.exceptionMessages.size(), (OutputStream)outputStream);
        for (PipeRuntimeException pipeRuntimeException : this.exceptionMessages.values()) {
            pipeRuntimeException.serialize(outputStream);
        }
    }

    public static PipeTaskMeta deserialize(PipeRuntimeMetaVersion version, ByteBuffer byteBuffer) {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
        int leaderDataNodeId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta(progressIndex, leaderDataNodeId);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(version, byteBuffer);
            pipeTaskMeta.exceptionMessages.put(pipeRuntimeException, pipeRuntimeException);
        }
        return pipeTaskMeta;
    }

    public static PipeTaskMeta deserialize(PipeRuntimeMetaVersion version, InputStream inputStream) throws IOException {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(inputStream);
        int leaderDataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta(progressIndex, leaderDataNodeId);
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(version, inputStream);
            pipeTaskMeta.exceptionMessages.put(pipeRuntimeException, pipeRuntimeException);
        }
        return pipeTaskMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskMeta that = (PipeTaskMeta)obj;
        return this.progressIndex.get().equals(that.progressIndex.get()) && this.leaderDataNodeId.get() == that.leaderDataNodeId.get() && this.exceptionMessages.equals(that.exceptionMessages);
    }

    public int hashCode() {
        return Objects.hash(this.progressIndex.get(), this.leaderDataNodeId.get(), this.exceptionMessages);
    }

    public String toString() {
        return "PipeTask{progressIndex='" + this.progressIndex + "', leaderDataNodeId=" + this.leaderDataNodeId + ", exceptionMessages='" + this.exceptionMessages + "'}";
    }
}

