/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.IUserAccessor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUserAccessor
implements IUserAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileUserAccessor.class);
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private static final String USER_SNAPSHOT_FILE_NAME = "system" + File.separator + "users";
    private static final String ROLE_SUFFIX = "_role";
    private final String userDirPath;
    private final ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private final ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileUserAccessor(String userDirPath) {
        this.userDirPath = userDirPath;
    }

    @Override
    public User loadUser(String username) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile");
        if (!userProfile.exists() || !userProfile.isFile()) {
            File newProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile" + TEMP_SUFFIX);
            if (newProfile.exists() && newProfile.isFile()) {
                if (!newProfile.renameTo(userProfile)) {
                    LOGGER.error("New profile renaming not succeed.");
                }
                userProfile = newProfile;
            } else {
                return null;
            }
        }
        FileInputStream inputStream = new FileInputStream(userProfile);
        try {
            User user;
            User user2;
            DataInputStream dataInputStream;
            block29: {
                dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                user2 = new User();
                Pair<String, Boolean> result = IOUtils.readAuthString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
                boolean oldVersion = (Boolean)result.getRight();
                user2.setName((String)result.getLeft());
                user2.setPassword(IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                if (!oldVersion) break block29;
                IOUtils.loadRolePrivilege(user2, dataInputStream, STRING_ENCODING, this.strBufferLocal);
                int roleNum = dataInputStream.readInt();
                ArrayList<String> roleList = new ArrayList<String>();
                for (int i = 0; i < roleNum; ++i) {
                    String roleName = IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal);
                    roleList.add(roleName);
                }
                user2.setRoleList(roleList);
                try {
                    user2.setUseWaterMark(dataInputStream.readInt() != 0);
                }
                catch (EOFException e1) {
                    user2.setUseWaterMark(false);
                }
                User e1 = user2;
                dataInputStream.close();
                return e1;
            }
            try {
                File newRoleProfile;
                user2.setSysPrivilegeSet(dataInputStream.readInt());
                ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                int i = 0;
                while (dataInputStream.available() != 0) {
                    pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal, false));
                    ++i;
                }
                user2.setPrivilegeList(pathPrivilegeList);
                File roleOfUser = SystemFileFactory.INSTANCE.getFile(this.userDirPath, File.separator + username + ROLE_SUFFIX + ".profile");
                if ((!roleOfUser.isFile() || !roleOfUser.exists()) && (newRoleProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ROLE_SUFFIX + ".profile" + TEMP_SUFFIX)).exists() && newRoleProfile.isFile()) {
                    if (!newRoleProfile.renameTo(roleOfUser)) {
                        LOGGER.warn(" New role profile renaming not succeed.");
                    }
                    roleOfUser = newRoleProfile;
                }
                ArrayList<String> roleList = new ArrayList<String>();
                if (roleOfUser.exists()) {
                    inputStream = new FileInputStream(roleOfUser);
                    try (DataInputStream roleInpuStream = new DataInputStream(new BufferedInputStream(inputStream));){
                        int i2 = 0;
                        while (roleInpuStream.available() != 0) {
                            String rolename = IOUtils.readString(roleInpuStream, STRING_ENCODING, this.strBufferLocal);
                            roleList.add(rolename);
                            ++i2;
                        }
                    }
                }
                user2.setRoleList(roleList);
                user = user2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return user;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    @Override
    public void saveUser(User user) throws IOException {
        int i;
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile" + TEMP_SUFFIX);
        FileOutputStream fileOutputStream = new FileOutputStream(userProfile);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            byte[] strBuffer = user.getName().getBytes(STRING_ENCODING);
            IOUtils.writeInt(outputStream, -1 * strBuffer.length, this.encodingBufferLocal);
            outputStream.write(strBuffer);
            IOUtils.writeString(outputStream, user.getPassword(), STRING_ENCODING, this.encodingBufferLocal);
            IOUtils.writeInt(outputStream, user.getAllSysPrivileges(), this.encodingBufferLocal);
            int privilegeNum = user.getPathPrivilegeList().size();
            for (i = 0; i < privilegeNum; ++i) {
                PathPrivilege pathPrivilege = user.getPathPrivilegeList().get(i);
                IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
            this.encodingBufferLocal.remove();
        }
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ROLE_SUFFIX + ".profile" + TEMP_SUFFIX);
        fileOutputStream = new FileOutputStream(roleProfile);
        outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            int userNum = user.getRoleList().size();
            for (i = 0; i < userNum; ++i) {
                IOUtils.writeString(outputStream, user.getRoleList().get(i), STRING_ENCODING, this.encodingBufferLocal);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
            this.encodingBufferLocal.remove();
        }
        File oldUserFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile");
        IOUtils.replaceFile(userProfile, oldUserFile);
        File oldURoleFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ROLE_SUFFIX + ".profile");
        IOUtils.replaceFile(roleProfile, oldURoleFile);
    }

    @Override
    public boolean deleteUser(String username) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile" + TEMP_SUFFIX);
        if (!userProfile.exists() && !backFile.exists()) {
            return true;
        }
        if (userProfile.exists() && !userProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete user file of %s", username));
        }
        return this.deleteURole(username);
    }

    public boolean deleteURole(String username) throws IOException {
        File uRoleProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ROLE_SUFFIX + ".profile");
        File backProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ROLE_SUFFIX + ".profile" + TEMP_SUFFIX);
        if (!uRoleProfile.exists() && !backProfile.exists()) {
            return true;
        }
        if (uRoleProfile.exists() && !uRoleProfile.delete() || backProfile.exists() && !backProfile.delete()) {
            throw new IOException(String.format("Catch error when delete %s 's role", username));
        }
        return true;
    }

    @Override
    public List<String> listAllUsers() {
        File userDir = SystemFileFactory.INSTANCE.getFile(this.userDirPath);
        String[] names = userDir.list((dir, name) -> name.endsWith(".profile") && !name.endsWith("_role.profile") || name.endsWith(TEMP_SUFFIX) && !name.endsWith("_role.temp"));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File userFolder = systemFileFactory.getFile(this.userDirPath);
        File userSnapshotDir = systemFileFactory.getFile(snapshotDir, USER_SNAPSHOT_FILE_NAME);
        File userTmpSnapshotDir = systemFileFactory.getFile(userSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        boolean result = true;
        try {
            result = org.apache.iotdb.commons.utils.FileUtils.copyDir(userFolder, userTmpSnapshotDir);
        }
        finally {
            if (userTmpSnapshotDir.exists() && !userTmpSnapshotDir.delete()) {
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userTmpSnapshotDir);
            }
        }
        return result &= userTmpSnapshotDir.renameTo(userSnapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File userFolder = systemFileFactory.getFile(this.userDirPath);
        File userTmpFolder = systemFileFactory.getFile(userFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File userSnapshotDir = systemFileFactory.getFile(snapshotDir, USER_SNAPSHOT_FILE_NAME);
        try {
            FileUtils.moveDirectory((File)userFolder, (File)userTmpFolder);
            if (!org.apache.iotdb.commons.utils.FileUtils.copyDir(userSnapshotDir, userFolder)) {
                LOGGER.error("Failed to load user folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userFolder);
                FileUtils.moveDirectory((File)userTmpFolder, (File)userFolder);
            }
        }
        finally {
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userTmpFolder);
        }
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.userDirPath).mkdirs()) {
            LOGGER.info("user info dir {} is created", (Object)this.userDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.userDirPath).exists()) {
            LOGGER.error("user info dir {} can not be created", (Object)this.userDirPath);
        }
    }

    @Override
    public String getDirPath() {
        return this.userDirPath;
    }

    @Override
    public void cleanUserFolder() {
        File[] files;
        for (File file : files = SystemFileFactory.INSTANCE.getFile(this.userDirPath).listFiles()) {
            org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserOldVersion(User user) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile" + TEMP_SUFFIX);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(userProfile.toPath(), new OpenOption[0]));){
            try {
                IOUtils.writeString(outputStream, user.getName(), STRING_ENCODING, this.encodingBufferLocal);
                IOUtils.writeString(outputStream, user.getPassword(), STRING_ENCODING, this.encodingBufferLocal);
                int privilegeNum = user.getPathPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = user.getPathPrivilegeList().get(i);
                    IOUtils.writeString(outputStream, pathPrivilege.getPath().getFullPath(), STRING_ENCODING, this.encodingBufferLocal);
                    IOUtils.writeInt(outputStream, pathPrivilege.getPrivileges().size(), this.encodingBufferLocal);
                    for (Integer item : pathPrivilege.getPrivileges()) {
                        IOUtils.writeInt(outputStream, item, this.encodingBufferLocal);
                    }
                }
                int userNum = user.getRoleList().size();
                IOUtils.writeInt(outputStream, userNum, this.encodingBufferLocal);
                for (int i = 0; i < userNum; ++i) {
                    IOUtils.writeString(outputStream, user.getRoleList().get(i), STRING_ENCODING, this.encodingBufferLocal);
                }
                IOUtils.writeInt(outputStream, user.isUseWaterMark() ? 1 : 0, this.encodingBufferLocal);
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile");
        IOUtils.replaceFile(userProfile, oldFile);
    }
}

