/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.serialization.Expose;
import java.util.ArrayList;
import java.util.List;

class Stackframe {
    private Configuration config;
    private StackTraceElement el;

    Stackframe(Configuration config, StackTraceElement el) {
        this.config = config;
        this.el = el;
    }

    static List<Stackframe> getStacktrace(Configuration config, StackTraceElement[] elements) {
        ArrayList<Stackframe> stacktrace = new ArrayList<Stackframe>();
        for (StackTraceElement el : elements) {
            stacktrace.add(new Stackframe(config, el));
        }
        return stacktrace;
    }

    @Expose
    public String getFile() {
        return this.el.getFileName() == null ? "Unknown" : this.el.getFileName();
    }

    @Expose
    public String getMethod() {
        return this.el.getClassName() + "." + this.el.getMethodName();
    }

    @Expose
    public int getLineNumber() {
        return this.el.getLineNumber();
    }

    @Expose
    public boolean isInProject() {
        return this.config.inProject(this.el.getClassName());
    }
}

