/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TimeDuration;

public class GroupByMonthFilter
extends GroupByFilter {
    private Calendar calendar = Calendar.getInstance();
    private TimeDuration originalSlidingStep;
    private TimeDuration originalInterval;
    private TimeZone timeZone;
    private long originalStartTime;
    private long originalEndTime;
    private TimeUnit currPrecision;
    private long[] startTimes;

    public GroupByMonthFilter() {
    }

    public GroupByMonthFilter(TimeDuration interval, TimeDuration slidingStep, long startTime, long endTime, TimeZone timeZone, TimeUnit currPrecision) {
        super(startTime, endTime);
        this.originalInterval = interval;
        this.originalSlidingStep = slidingStep;
        if (!interval.containsMonth()) {
            this.interval = interval.nonMonthDuration;
        }
        if (!slidingStep.containsMonth()) {
            this.slidingStep = slidingStep.nonMonthDuration;
        }
        this.originalStartTime = startTime;
        this.originalEndTime = endTime;
        this.currPrecision = currPrecision;
        this.initMonthGroupByParameters(timeZone);
    }

    public GroupByMonthFilter(GroupByMonthFilter filter) {
        super(filter.interval, filter.slidingStep, filter.startTime, filter.endTime);
        this.originalStartTime = filter.originalStartTime;
        this.originalEndTime = filter.originalEndTime;
        this.originalSlidingStep = filter.originalSlidingStep;
        this.originalInterval = filter.originalInterval;
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(filter.calendar.getTimeZone());
        this.calendar.setTimeInMillis(filter.calendar.getTimeInMillis());
        this.timeZone = filter.timeZone;
        this.currPrecision = filter.currPrecision;
        this.startTimes = filter.startTimes;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (time < this.originalStartTime || time >= this.endTime) {
            return false;
        }
        if (time >= this.startTime && time < this.startTime + this.slidingStep) {
            return time - this.startTime < this.interval;
        }
        int count = this.getTimePointPosition(time);
        this.getNthTimeInterval(count);
        return time - this.startTime < this.interval;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        int count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        this.getNthTimeInterval(count + 1);
        return this.satisfyCurrentInterval(startTime, endTime);
    }

    @Override
    public Filter copy() {
        return new GroupByMonthFilter(this);
    }

    private boolean satisfyCurrentInterval(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.isContainedByCurrentInterval(startTime, endTime)) {
            return true;
        }
        int count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        return this.isContainedByCurrentInterval(startTime, endTime);
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            this.originalInterval.serialize(outputStream);
            this.originalSlidingStep.serialize(outputStream);
            ReadWriteIOUtils.write(this.originalStartTime, (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.originalEndTime, (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.currPrecision.ordinal(), (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.timeZone.getID(), (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.originalInterval = TimeDuration.deserialize(buffer);
        this.originalSlidingStep = TimeDuration.deserialize(buffer);
        if (!this.originalInterval.containsMonth()) {
            this.interval = this.originalInterval.nonMonthDuration;
        }
        if (!this.originalSlidingStep.containsMonth()) {
            this.slidingStep = this.originalSlidingStep.nonMonthDuration;
        }
        this.originalStartTime = ReadWriteIOUtils.readLong(buffer);
        this.originalEndTime = ReadWriteIOUtils.readLong(buffer);
        this.currPrecision = TimeUnit.values()[ReadWriteIOUtils.readInt(buffer)];
        this.timeZone = TimeZone.getTimeZone(ReadWriteIOUtils.readString(buffer));
        this.startTime = this.originalStartTime;
        this.endTime = this.originalEndTime;
        this.initMonthGroupByParameters(this.timeZone);
    }

    private boolean isContainedByCurrentInterval(long startTime, long endTime) {
        if (startTime < this.startTime || endTime > this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval && endTime - this.startTime < this.interval;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByMonthFilter)) {
            return false;
        }
        GroupByMonthFilter other = (GroupByMonthFilter)obj;
        return this.originalInterval.equals(other.originalInterval) && this.originalSlidingStep.equals(other.originalSlidingStep) && this.originalStartTime == other.originalStartTime && this.originalEndTime == other.originalEndTime && this.currPrecision == other.currPrecision && this.timeZone.equals(other.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.originalInterval, this.originalSlidingStep, this.originalStartTime, this.originalEndTime);
    }

    private void initMonthGroupByParameters(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
        this.timeZone = timeZone;
        this.calendar.setTimeInMillis(this.startTime);
        if (this.originalSlidingStep.containsMonth()) {
            this.startTimes = TimeDuration.getConsecutiveTimesIntervalByMonth(this.startTime, this.originalSlidingStep, (int)Math.ceil((double)(this.originalEndTime - this.originalStartTime) / (double)this.originalSlidingStep.getMinTotalDuration(this.currPrecision)), timeZone, this.currPrecision);
        }
        this.getNthTimeInterval(0);
    }

    private int getTimePointPosition(long time) {
        if (this.originalSlidingStep.containsMonth()) {
            int searchResult = Arrays.binarySearch(this.startTimes, time);
            return searchResult >= 0 ? searchResult : Math.max(0, Math.abs(searchResult) - 2);
        }
        return (int)((time - this.originalStartTime) / this.slidingStep);
    }

    private void getNthTimeInterval(int n) {
        if (this.originalSlidingStep.containsMonth()) {
            if (n < 0 || n > this.startTimes.length - 1) {
                this.interval = -1L;
                return;
            }
            this.startTime = this.startTimes[n];
            this.slidingStep = TimeDuration.calcPositiveIntervalByMonth(this.startTime, this.originalSlidingStep, 1L, this.timeZone, this.currPrecision) - this.startTime;
        } else {
            this.startTime = this.originalStartTime + (long)n * this.slidingStep;
        }
        if (this.originalInterval.containsMonth()) {
            this.interval = TimeDuration.calcPositiveIntervalByMonth(this.startTime, this.originalInterval, 1L, this.timeZone, this.currPrecision) - this.startTime;
        }
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.GROUP_BY_MONTH;
    }
}

