/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.allocation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.allocation.AbstractNodeAllocationStrategy;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;

public class FirstCreateStrategy
extends AbstractNodeAllocationStrategy {
    private final Lock nodesLock = new ReentrantLock();
    private final Map<String, WALNode> identifier2Nodes = new HashMap<String, WALNode>();

    @Override
    public IWALNode applyForWALNode(String applicantUniqueId) {
        this.nodesLock.lock();
        try {
            IWALNode walNode;
            if (!this.identifier2Nodes.containsKey(applicantUniqueId) && (walNode = this.createWALNode(applicantUniqueId)) instanceof WALNode) {
                walNode.setSafelyDeletedSearchIndex(Long.MIN_VALUE);
                this.identifier2Nodes.put(applicantUniqueId, (WALNode)walNode);
            }
            IWALNode iWALNode = this.identifier2Nodes.get(applicantUniqueId);
            return iWALNode;
        }
        finally {
            this.nodesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWALNode(String applicantUniqueId, String logDirectory, long startFileVersion, long startSearchIndex) {
        this.nodesLock.lock();
        try {
            if (this.identifier2Nodes.containsKey(applicantUniqueId)) {
                return;
            }
            IWALNode walNode = this.createWALNode(applicantUniqueId, logDirectory, startFileVersion, startSearchIndex);
            if (walNode instanceof WALNode) {
                walNode.setSafelyDeletedSearchIndex(Long.MIN_VALUE);
                this.identifier2Nodes.put(applicantUniqueId, (WALNode)walNode);
            }
        }
        finally {
            this.nodesLock.unlock();
        }
    }

    public void deleteWALNode(String applicantUniqueId) {
        this.nodesLock.lock();
        try {
            WALNode walNode = this.identifier2Nodes.remove(applicantUniqueId);
            if (walNode != null) {
                walNode.close();
                if (walNode.getLogDirectory().exists()) {
                    FileUtils.deleteDirectory((File)walNode.getLogDirectory());
                }
                WALManager.getInstance().subtractTotalDiskUsage(walNode.getDiskUsage());
                WALManager.getInstance().subtractTotalFileNum(walNode.getFileNum());
            }
        }
        finally {
            this.nodesLock.unlock();
        }
    }

    @Override
    public List<WALNode> getNodesSnapshot() {
        ArrayList<WALNode> snapshot;
        this.nodesLock.lock();
        try {
            snapshot = new ArrayList<WALNode>(this.identifier2Nodes.values());
        }
        finally {
            this.nodesLock.unlock();
        }
        return snapshot;
    }

    @Override
    public int getNodesNum() {
        return this.identifier2Nodes.size();
    }

    @Override
    public void clear() {
        this.nodesLock.lock();
        try {
            for (WALNode walNode : this.identifier2Nodes.values()) {
                walNode.close();
            }
            this.identifier2Nodes.clear();
        }
        finally {
            this.nodesLock.unlock();
        }
    }
}

